/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.registry;

import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.registry.Registry;
import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryBase<T extends IDeyed>
implements Registry<T> {
    protected final Map<String, T> entries = new THashMap();

    @Override
    @Nullable
    public T get(@NotNull String id) {
        return (T)((IDeyed)this.entries.get(id.toLowerCase()));
    }

    @Override
    @NotNull
    public Collection<T> getEntries() {
        return this.entries.values();
    }

    @Override
    @NotNull
    public Collection<String> getIds() {
        return this.entries.keySet();
    }

    @Override
    public void register(@NotNull T entry) {
        this.entries.put(entry.getId(), entry);
    }

    @Override
    public void unregister(@NotNull String id) {
        this.entries.remove(id.toLowerCase());
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.entries.values().iterator();
    }
}

