/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.registry;

import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.registry.ConfigurationRegistry;
import es.outlook.adriansrj.cv.api.registry.RegistryBase;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurationRegistryBase<T extends IDeyed>
extends RegistryBase<T>
implements ConfigurationRegistry<T> {
    @NotNull
    protected abstract File getFolder();

    @Override
    public void load() {
        File folder = this.getFolder();
        if (folder.exists()) {
            for (File file : Objects.requireNonNull(folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml")))) {
                try {
                    T value = this.loadEntry(file);
                    if (value == null) continue;
                    this.register(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected abstract T loadEntry(File var1) throws Exception;

    @Override
    public void reload() {
        try {
            this.saveDefaults();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.entries.clear();
        this.load();
    }

    @Nullable
    protected abstract Set<T> getDefaults();

    @Override
    public void saveDefaults() throws IOException {
        Set<T> defaults = this.getDefaults();
        File folder = this.getFolder();
        if (defaults == null || defaults.isEmpty() || folder.exists()) {
            return;
        }
        if (!folder.mkdirs()) {
            throw new IllegalStateException("couldn't create " + folder.getName() + " folder");
        }
        for (IDeyed entry : defaults) {
            try {
                this.saveDefault(entry, new File(folder, entry.getId() + ".yml"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void saveDefault(T defaultEntry, File file) throws Exception {
        if (!file.exists() && !file.createNewFile()) {
            throw new IllegalStateException("couldn't create configuration file for default entry (" + file.getName() + ")");
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        this.writeEntry(defaultEntry, yaml);
        yaml.save(file);
    }

    protected abstract void writeEntry(@NotNull T var1, YamlConfiguration var2);
}

