/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.item;

import es.outlook.adriansrj.cv.api.CraftyVehicles;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.item.ItemConfiguration;
import es.outlook.adriansrj.cv.api.registry.Registries;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeConfiguration
implements ConfigurationSectionWritable {
    @NotNull
    private final String result;
    @NotNull
    private final Shape shape;

    public static RecipeConfiguration load(ConfigurationSection section) throws InvalidConfigurationException {
        String result = section.getString("result");
        if (StringUtils.isBlank((String)result)) {
            throw new InvalidConfigurationException("invalid result");
        }
        Shaped shaped = null;
        Shapeless shapeless = null;
        if (section.contains("shaped")) {
            shaped = Shaped.parse(section, "shaped");
        } else if (section.contains("shapeless")) {
            shapeless = Shapeless.parse(section, "shapeless");
        }
        if (shaped != null) {
            return new RecipeConfiguration(result, shaped);
        }
        if (shapeless != null) {
            return new RecipeConfiguration(result, shapeless);
        }
        throw new InvalidConfigurationException("a valid shape must be set");
    }

    public RecipeConfiguration(@NotNull String result, @NotNull Shape shape) {
        this.result = result;
        this.shape = shape;
    }

    @Nullable
    public Recipe getRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)CraftyVehicles.getPlugin(), UUID.randomUUID().toString());
        ItemConfiguration result = (ItemConfiguration)Registries.getRegistry(ItemConfiguration.class).get(this.result);
        if (result == null) {
            return null;
        }
        if (this.shape instanceof Shaped) {
            Shaped shaped = (Shaped)this.shape;
            ShapedRecipe recipe = new ShapedRecipe(key, result.getItemStack());
            recipe.shape(new String[]{"012", "345", "678"});
            for (int i = 0; i < shaped.value.length; ++i) {
                String id = shaped.value[i];
                RecipeChoice choice = this.createChoice(id);
                if (choice == null) continue;
                recipe.setIngredient(String.valueOf(i).charAt(0), choice);
            }
            return recipe;
        }
        if (this.shape instanceof Shapeless) {
            ShapelessRecipe recipe = new ShapelessRecipe(key, result.getItemStack());
            for (String id : ((Shapeless)this.shape).value) {
                RecipeChoice choice = this.createChoice(id);
                if (choice == null) continue;
                recipe.addIngredient(choice);
            }
            return recipe;
        }
        return null;
    }

    private RecipeChoice createChoice(String ingredientId) {
        if (StringUtils.isBlank((String)ingredientId)) {
            return null;
        }
        ItemConfiguration pluginItem = (ItemConfiguration)Registries.getRegistry(ItemConfiguration.class).get(ingredientId);
        if (pluginItem != null) {
            ItemStack item = pluginItem.getItemStack();
            item.setAmount(1);
            return new RecipeChoice.ExactChoice(item);
        }
        Material material = EnumReflection.getEnumConstant(Material.class, ingredientId.trim().toUpperCase());
        if (material != null) {
            return new RecipeChoice.MaterialChoice(material);
        }
        return null;
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        section.set("result", (Object)this.result);
        this.shape.write(section, this.shape instanceof Shaped ? "shaped" : "shapeless");
    }

    public static class Shaped
    extends Shape {
        @NotNull
        private final String[] value = new String[9];

        public static Shaped parse(@NotNull ConfigurationSection section, @NotNull String key) throws InvalidConfigurationException {
            List serialized = section.getStringList(key);
            String[] value = new String[9];
            boolean invalid = true;
            block0: for (int row = 0; row < serialized.size() && row < 3; ++row) {
                String rowString = (String)serialized.get(row);
                if (StringUtils.isBlank((String)rowString)) continue;
                int count = 0;
                while (true) {
                    int startIndex = rowString.indexOf(91);
                    int endIndex = rowString.indexOf(93);
                    if (startIndex == -1 || endIndex == -1 || startIndex > endIndex) continue block0;
                    String ingredientId = rowString.substring(startIndex + 1, endIndex).trim().replace("[", "").replace("]", "");
                    if (StringUtils.isNotBlank((String)ingredientId)) {
                        invalid = false;
                        value[row * 3 + count] = ingredientId;
                    }
                    String string = rowString = rowString.length() > endIndex + 1 ? rowString.substring(endIndex + 1) : "";
                    if (count + 1 >= 3) continue block0;
                    ++count;
                }
            }
            if (invalid) {
                throw new InvalidConfigurationException("at least one ingredient must be set");
            }
            return new Shaped(value);
        }

        public Shaped(@NotNull String[] value) throws InvalidConfigurationException {
            if (value.length != this.value.length) {
                throw new InvalidConfigurationException("invalid value");
            }
            System.arraycopy(value, 0, this.value, 0, this.value.length);
        }

        @Override
        public void write(@NotNull ConfigurationSection section, @NotNull String key) {
            ArrayList<String> serialized = new ArrayList<String>();
            for (int row = 0; row < 3; ++row) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < 3; ++i) {
                    builder.append('[');
                    String ingredientId = this.value[row * 3 + i];
                    if (StringUtils.isNotBlank((String)ingredientId)) {
                        builder.append(ingredientId);
                    }
                    builder.append(']');
                }
                serialized.add(builder.toString());
            }
            section.set(key, serialized);
        }
    }

    public static class Shapeless
    extends Shape {
        @NotNull
        private final Set<String> value = new LinkedHashSet<String>();

        public static Shapeless parse(@NotNull ConfigurationSection section, @NotNull String key) throws InvalidConfigurationException {
            ArrayList<String> value = new ArrayList<String>(section.getStringList(key));
            if (value.size() == 0) {
                throw new InvalidConfigurationException("at least one ingredient must be set");
            }
            for (int i = 0; i < value.size(); ++i) {
                String ingredient = (String)value.get(i);
                if (!StringUtils.isNotBlank((String)ingredient)) continue;
                value.set(i, ingredient.trim());
            }
            return new Shapeless(value);
        }

        public Shapeless(@NotNull Collection<String> value) throws InvalidConfigurationException {
            if (value.size() == 0) {
                throw new InvalidConfigurationException("invalid value");
            }
            this.value.addAll(value);
        }

        @Override
        public void write(@NotNull ConfigurationSection section, @NotNull String key) {
            section.set(key, new ArrayList<String>(this.value));
        }
    }

    public static abstract class Shape {
        public abstract void write(@NotNull ConfigurationSection var1, @NotNull String var2);
    }
}

