/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.item;

import es.outlook.adriansrj.cv.api.CraftyVehicles;
import es.outlook.adriansrj.cv.api.interfaces.ConfigurationSectionWritable;
import es.outlook.adriansrj.cv.api.interfaces.IDeyed;
import es.outlook.adriansrj.cv.api.registry.Registries;
import es.outlook.adriansrj.cv.api.util.ConfigurationUtil;
import es.outlook.adriansrj.cv.api.util.Constants;
import es.outlook.adriansrj.cv.api.util.LangFormatter;
import es.outlook.adriansrj.cv.api.util.inventory.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConfiguration
implements IDeyed,
ConfigurationSectionWritable {
    private static final String SPAWN_ACTION_TYPE = "spawn";
    private static final String FUEL_ACTION_TYPE = "fuel";
    @NotNull
    private final String id;
    @NotNull
    private final Material material;
    @Nullable
    private final String displayName;
    @Nullable
    private final List<String> description;
    @Nullable
    private final Integer customModelData;
    @Nullable
    private final String headTexture;
    @Nullable
    private final Action action;

    @NotNull
    public static ItemStack buildItemStack(@NotNull ItemConfiguration configuration) {
        ItemStack item = ItemStackUtil.buildCustomItem(configuration.material, configuration.customModelData, configuration.displayName, configuration.description);
        if (ItemStackUtil.isHead(configuration.material) && StringUtils.isNotBlank((String)configuration.headTexture)) {
            CraftyVehicles.getTexturedHeadService().applyTexture(item, configuration.headTexture);
        }
        ItemStackUtil.setPersistentData(item, Constants.NamespacedKeys.ITEM_ID, PersistentDataType.STRING, configuration.id);
        return item;
    }

    @NotNull
    public static ItemStack buildFuelItemStack(@NotNull ItemConfiguration configuration, float remainingFuel) {
        ItemStack item = ItemConfiguration.buildItemStack(configuration);
        if (configuration.displayName != null) {
            ItemStackUtil.setDisplayName(item, ItemConfiguration.formatFuel(configuration.displayName, remainingFuel));
        }
        if (configuration.description != null) {
            ArrayList<String> lore = new ArrayList<String>();
            configuration.description.forEach(line -> lore.add(ItemConfiguration.formatFuel(line, remainingFuel)));
            ItemStackUtil.setLore(item, lore);
        }
        return item;
    }

    private static String formatFuel(@NotNull String context, float fuel) {
        return LangFormatter.single(context).arg('f', String.format("%.2f", Float.valueOf(fuel))).format();
    }

    @Nullable
    public static String getItemId(@NotNull ItemStack vehicleItem) {
        return (String)ItemStackUtil.getPersistentData(vehicleItem, Constants.NamespacedKeys.ITEM_ID, PersistentDataType.STRING);
    }

    @Nullable
    public static ItemConfiguration matchItemConfiguration(@NotNull ItemStack vehicleItem) {
        String itemId = ItemConfiguration.getItemId(vehicleItem);
        if (StringUtils.isNotBlank((String)itemId)) {
            return (ItemConfiguration)Registries.getRegistry(ItemConfiguration.class).get(itemId);
        }
        return null;
    }

    public static ItemConfiguration load(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        Material material = ConfigurationUtil.loadEnum(Material.class, section, "material");
        if (material == null) {
            throw new InvalidConfigurationException("invalid material: " + section.getString("material"));
        }
        String displayName = section.getString("display-name");
        List description = section.getStringList("description");
        String headTexture = section.getString("head-texture");
        Object customModelDataRaw = section.get("custom-model-data");
        Integer customModelData = customModelDataRaw instanceof Number ? Integer.valueOf(((Number)customModelDataRaw).intValue()) : null;
        ConfigurationSection actionSection = section.getConfigurationSection("action");
        Action action = actionSection != null ? Action.load(actionSection) : null;
        return new ItemConfiguration(IDeyed.loadId(section), material, displayName, description, customModelData, headTexture, action);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ItemStack getItemStack() {
        if (this.action instanceof FuelAction) {
            return ItemConfiguration.buildFuelItemStack(this, ((FuelAction)this.action).fuelAmount);
        }
        return ItemConfiguration.buildItemStack(this);
    }

    @Override
    public void write(@NotNull ConfigurationSection section) {
        IDeyed.writeId(this, section);
        ConfigurationUtil.writeEnum(this.material, section, "material");
        section.set("display-name", (Object)this.displayName);
        section.set("description", this.description != null && this.description.size() > 0 ? this.description : null);
        section.set("custom-model-data", (Object)this.customModelData);
        section.set("head-texture", (Object)this.headTexture);
        if (this.action != null) {
            this.action.write(section.createSection("action"));
        }
    }

    public static ItemConfigurationBuilder builder() {
        return new ItemConfigurationBuilder();
    }

    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public List<String> getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getCustomModelData() {
        return this.customModelData;
    }

    @Nullable
    public String getHeadTexture() {
        return this.headTexture;
    }

    @Nullable
    public Action getAction() {
        return this.action;
    }

    public ItemConfiguration(@NotNull String id, @NotNull Material material, @Nullable String displayName, @Nullable List<String> description, @Nullable Integer customModelData, @Nullable String headTexture, @Nullable Action action) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        this.id = id;
        this.material = material;
        this.displayName = displayName;
        this.description = description;
        this.customModelData = customModelData;
        this.headTexture = headTexture;
        this.action = action;
    }

    public static abstract class Action
    implements ConfigurationSectionWritable {
        public static Action load(@NotNull ConfigurationSection section) {
            String type = section.getString("type");
            if (type != null) {
                switch (type.toLowerCase().trim()) {
                    case "spawn": {
                        return new SpawnAction(section);
                    }
                    case "fuel": {
                        return new FuelAction(section);
                    }
                }
            }
            return null;
        }

        @NotNull
        abstract String getTypeIdentifier();

        @Override
        public void write(@NotNull ConfigurationSection section) {
            section.set("type", (Object)this.getTypeIdentifier().trim().toLowerCase());
        }
    }

    public static class FuelAction
    extends Action {
        private final float fuelAmount;

        public FuelAction(@NotNull ConfigurationSection section) {
            this.fuelAmount = (float)section.getDouble("fuel-amount");
        }

        @Override
        @NotNull
        String getTypeIdentifier() {
            return ItemConfiguration.FUEL_ACTION_TYPE;
        }

        @Override
        public void write(@NotNull ConfigurationSection section) {
            super.write(section);
            section.set("fuel-amount", (Object)Float.valueOf(this.fuelAmount));
        }

        public float getFuelAmount() {
            return this.fuelAmount;
        }

        public FuelAction(float fuelAmount) {
            this.fuelAmount = fuelAmount;
        }
    }

    public static class ItemConfigurationBuilder {
        private String id;
        private Material material;
        private String displayName;
        private List<String> description;
        private Integer customModelData;
        private String headTexture;
        private Action action;

        ItemConfigurationBuilder() {
        }

        public ItemConfigurationBuilder id(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        public ItemConfigurationBuilder material(@NotNull Material material) {
            if (material == null) {
                throw new NullPointerException("material is marked non-null but is null");
            }
            this.material = material;
            return this;
        }

        public ItemConfigurationBuilder displayName(@Nullable String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ItemConfigurationBuilder description(@Nullable List<String> description) {
            this.description = description;
            return this;
        }

        public ItemConfigurationBuilder customModelData(@Nullable Integer customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public ItemConfigurationBuilder headTexture(@Nullable String headTexture) {
            this.headTexture = headTexture;
            return this;
        }

        public ItemConfigurationBuilder action(@Nullable Action action) {
            this.action = action;
            return this;
        }

        public ItemConfiguration build() {
            return new ItemConfiguration(this.id, this.material, this.displayName, this.description, this.customModelData, this.headTexture, this.action);
        }

        public String toString() {
            return "ItemConfiguration.ItemConfigurationBuilder(id=" + this.id + ", material=" + this.material + ", displayName=" + this.displayName + ", description=" + this.description + ", customModelData=" + this.customModelData + ", headTexture=" + this.headTexture + ", action=" + this.action + ")";
        }
    }

    public static class SpawnAction
    extends Action {
        @NotNull
        private final String vehicleId;

        public SpawnAction(@NotNull ConfigurationSection section) {
            this.vehicleId = section.getString("vehicle-id", "");
        }

        @Override
        @NotNull
        String getTypeIdentifier() {
            return ItemConfiguration.SPAWN_ACTION_TYPE;
        }

        @Override
        public void write(@NotNull ConfigurationSection section) {
            super.write(section);
            section.set("vehicle-id", (Object)this.vehicleId);
        }

        @NotNull
        public String getVehicleId() {
            return this.vehicleId;
        }

        public SpawnAction(@NotNull String vehicleId) {
            if (vehicleId == null) {
                throw new NullPointerException("vehicleId is marked non-null but is null");
            }
            this.vehicleId = vehicleId;
        }
    }
}

