/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.interfaces;

import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Named {
    public static boolean isValidName(@NotNull String name) {
        return StringUtils.isNotBlank((String)name) && name.toLowerCase().matches("[a-zA-Z0-9\\-_.]+");
    }

    public static String nameCheck(@NotNull String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name cannot be blank");
        }
        if (!name.matches("[a-zA-Z0-9\\-_.]+")) {
            throw new IllegalArgumentException("name contains invalid characters");
        }
        return name;
    }

    public static String loadName(@NotNull ConfigurationSection section, @Nullable String defaultName) throws InvalidConfigurationException {
        String name = section.getString("name", defaultName);
        if (name == null) {
            throw new InvalidConfigurationException("name must be set");
        }
        try {
            return Named.nameCheck(name);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidConfigurationException(ex.getMessage());
        }
    }

    public static String loadName(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        return Named.loadName(section, null);
    }

    public static void writeName(Named named, @NotNull ConfigurationSection section) {
        section.set("name", (Object)Named.nameCheck(named.getName()));
    }

    @NotNull
    public String getName();
}

