/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.interfaces;

import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Identifiable {
    @Nullable
    public static UUID loadIdentifier(@NotNull ConfigurationSection section) {
        String identifierString = section.getString("identifier");
        if (identifierString != null) {
            try {
                return UUID.fromString(identifierString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static UUID loadIdentifierOrGenerate(@NotNull ConfigurationSection section) {
        UUID identifier = Identifiable.loadIdentifier(section);
        return identifier != null ? identifier : UUID.randomUUID();
    }

    public static void writeIdentifier(@NotNull Identifiable identifiable, @NotNull ConfigurationSection section) {
        section.set("identifier", (Object)identifiable.getIdentifier().toString());
    }

    public static void writeIdentifier(@NotNull UUID identifier, @NotNull ConfigurationSection section) {
        section.set("identifier", (Object)identifier.toString());
    }

    @NotNull
    public UUID getIdentifier();
}

