/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.interfaces;

import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.jetbrains.annotations.NotNull;

public interface IDeyed {
    public static boolean isValidId(@NotNull String id) {
        return StringUtils.isNotBlank((String)id) && id.toLowerCase().matches("[a-z0-9\\-_.]+");
    }

    public static String idCheck(@NotNull String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id cannot be blank");
        }
        if (!id.toLowerCase().matches("[a-z0-9\\-_.]+")) {
            throw new IllegalArgumentException("id contains invalid characters");
        }
        return id.toLowerCase();
    }

    public static String loadId(@NotNull ConfigurationSection section) throws InvalidConfigurationException {
        String id = section.getString("id");
        if (id == null) {
            throw new InvalidConfigurationException("id must be set");
        }
        try {
            return IDeyed.idCheck(id.toLowerCase());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidConfigurationException(ex.getMessage());
        }
    }

    public static void writeId(IDeyed ideyed, @NotNull ConfigurationSection section) {
        section.set("id", (Object)IDeyed.idCheck(ideyed.getId()));
    }

    public static void writeId(@NotNull String id, @NotNull ConfigurationSection section) {
        section.set("id", (Object)IDeyed.idCheck(id));
    }

    @NotNull
    public String getId();
}

