/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.enums;

import es.outlook.adriansrj.cv.api.interfaces.VersionSensible;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import org.bukkit.Bukkit;

@VersionSensible
public enum EnumServerVersion {
    v1_9_R1,
    v1_9_R2,
    v1_10_R1,
    v1_11_R1,
    v1_12_R1,
    v1_13_R1,
    v1_13_R2,
    v1_14_R1,
    v1_15_R1,
    v1_16_R1,
    v1_16_R2,
    v1_16_R3,
    v1_17_R1,
    v1_18_R1,
    v1_18_R2,
    v1_19_R1,
    v1_19_R2,
    v1_19_R3,
    v1_20_R1,
    v1_20_R2;

    private final int id;

    private EnumServerVersion() {
        StringBuilder idBuilder = new StringBuilder();
        String enumName = this.name();
        for (int i = 0; i < enumName.length(); ++i) {
            char character = enumName.charAt(i);
            if (!Character.isDigit(character)) continue;
            idBuilder.append(character);
        }
        this.id = Integer.parseInt(idBuilder.toString());
    }

    public static EnumServerVersion getServerVersion() {
        String serverClassPackage = Bukkit.getServer().getClass().getPackage().getName();
        String version = serverClassPackage.substring(serverClassPackage.lastIndexOf(".") + 1);
        return EnumReflection.getEnumConstant(EnumServerVersion.class, version);
    }

    public int getId() {
        return this.id;
    }

    public boolean isOlder(EnumServerVersion other) {
        return this.getId() < other.getId();
    }

    public boolean isOlderEquals(EnumServerVersion other) {
        return this.getId() <= other.getId();
    }

    public boolean isNewer(EnumServerVersion other) {
        return this.getId() > other.getId();
    }

    public boolean isNewerEquals(EnumServerVersion other) {
        return this.getId() >= other.getId();
    }

    public boolean isSameVersion(EnumServerVersion other) {
        String s0 = this.name().substring(0, this.name().indexOf("_R"));
        String s1 = other.name().substring(0, other.name().indexOf("_R"));
        return s0.equals(s1);
    }

    public boolean isSameRevision(EnumServerVersion other) {
        String s0 = this.name().substring(this.name().indexOf("R") + 1);
        String s1 = other.name().substring(other.name().indexOf("R") + 1);
        return s0.equals(s1);
    }

    public boolean isSupportsDisplayEntities() {
        return this.id >= EnumServerVersion.v1_19_R3.id;
    }
}

