/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.configuration;

import es.outlook.adriansrj.cv.api.CraftyVehiclesPluginBase;
import es.outlook.adriansrj.cv.api.util.LangFormatter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class LangConfiguration {
    public static final Entry SPAWN_CANNOT_PLACE_HERE = new Entry("spawn.cannot-place-here", ChatColor.DARK_RED + "Cannot place this vehicle here!");
    public static final Entry FUEL_TANK_FULL = new Entry("fuel.tank-full", ChatColor.DARK_RED + "Vehicle tank is already full!");

    public static void load(@NotNull CraftyVehiclesPluginBase plugin) {
        File file = new File(plugin.getDataFolder(), "LanguageConfiguration.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                Files.createFile(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("couldn't generate language configuration file", e);
            }
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        for (Field field : LangConfiguration.class.getFields()) {
            if (!Entry.class.isAssignableFrom(field.getType())) continue;
            try {
                ((Entry)field.get(null)).load((ConfigurationSection)yaml);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        try {
            yaml.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final String defaultValue;
        @NotNull
        private String value;

        private Entry(@NotNull String key, @NotNull String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        @NotNull
        public String value() {
            return this.value;
        }

        @NotNull
        public LangFormatter valueWithFormat(boolean single) {
            return single ? LangFormatter.single(this.value()) : LangFormatter.multi(this.value());
        }

        private void load(@NotNull ConfigurationSection section) {
            String value = section.getString(this.key);
            if (StringUtils.isBlank((String)value)) {
                this.value = this.defaultValue;
                section.set(this.key, (Object)this.decompileColors(this.defaultValue));
            } else {
                this.value = ChatColor.translateAlternateColorCodes((char)'&', (String)value);
            }
        }

        private String decompileColors(String string) {
            char[] chars = string.toCharArray();
            for (int i = 0; i < chars.length - 1; ++i) {
                if (chars[i] != '\u00a7' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(chars[i + 1]) == -1) continue;
                chars[i] = 38;
            }
            return new String(chars);
        }
    }
}

