/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api.configuration;

import es.outlook.adriansrj.cv.api.CraftyVehiclesPluginBase;
import es.outlook.adriansrj.cv.api.util.reflection.EnumReflection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Configuration {
    public static final Entry OWNERSHIP_ONLY_OWNER = new Entry("ownership.only-owner-can-operate", false);
    public static final Entry FUEL_ENABLE = new Entry("fuel-system.enable", true);
    public static final Entry FUEL_BYPASS_CREATIVE = new Entry("fuel-system.bypass-creative-mode", true);
    public static final Entry PICKUP_ENABLE = new Entry("pickup-system.enable", true);
    public static final Entry PICKUP_PARTICLE_ENABLE = new Entry("pickup-system.particle.enable", true);
    public static final Entry PICKUP_PARTICLE_TYPE = new Entry("pickup-system.particle.type", Particle.CLOUD.name());
    public static final Entry PICKUP_PARTICLE_DISPERSION = new Entry("pickup-system.particle.dispersion", Float.valueOf(1.5f));
    public static final Entry PICKUP_PARTICLE_AMOUNT = new Entry("pickup-system.particle.amount", 20);
    public static final Entry PICKUP_SOUND_ENABLE = new Entry("pickup-system.sound.enable", true);
    public static final Entry PICKUP_SOUND_TYPE = new Entry("pickup-system.sound.type", Sound.ENTITY_CHICKEN_EGG.name());
    public static final Entry PICKUP_SOUND_VOLUME = new Entry("pickup-system.sound.volume", Float.valueOf(1.5f));
    public static final Entry PICKUP_SOUND_PITCH = new Entry("pickup-system.sound.pitch", Float.valueOf(1.0f));

    public static void load(@NotNull CraftyVehiclesPluginBase plugin) {
        File file = new File(plugin.getDataFolder(), "BaseConfiguration.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                Files.createFile(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("couldn't generate base configuration file", e);
            }
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        for (Field field : Configuration.class.getFields()) {
            if (!Entry.class.isAssignableFrom(field.getType())) continue;
            try {
                ((Entry)field.get(null)).load((ConfigurationSection)yaml);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        try {
            yaml.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final class Entry {
        @NotNull
        private final String key;
        @NotNull
        private final Object defaultValue;
        @Nullable
        private Object value;

        private Entry(@NotNull String key, @NotNull Object defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        @NotNull
        public Object value() {
            return this.value != null ? this.value : this.defaultValue;
        }

        @NotNull
        public <T> T value(@NotNull Class<T> type) {
            if (!this.compatible(type)) {
                throw new IllegalArgumentException("type mismatch");
            }
            return type.cast(this.value != null ? this.value : this.defaultValue);
        }

        public boolean booleanValue() {
            return this.value(Boolean.class);
        }

        @NotNull
        public Number numericValue() {
            return this.value(Number.class);
        }

        public int intValue() {
            return this.numericValue().intValue();
        }

        public long longValue() {
            return this.numericValue().longValue();
        }

        public double doubleValue() {
            return this.numericValue().doubleValue();
        }

        public float floatValue() {
            return this.numericValue().floatValue();
        }

        @NotNull
        public String stringValue() {
            return this.value(String.class);
        }

        @Nullable
        public <T extends Enum<T>> T enumValue(Class<T> type) {
            return EnumReflection.getEnumConstant(type, this.stringValue());
        }

        private void load(@NotNull ConfigurationSection section) {
            this.value = section.get(this.key);
            if (this.value == null || !this.compatible(this.value.getClass())) {
                this.value = this.defaultValue;
                section.set(this.key, this.defaultValue);
            }
        }

        private boolean compatible(@NotNull Class<?> type) {
            return this.defaultValue.getClass().isAssignableFrom(type) || this.defaultValue instanceof Number && Number.class.isAssignableFrom(type);
        }
    }
}

