/*
 * Decompiled with CFR 0.152.
 */
package es.outlook.adriansrj.cv.api;

import es.outlook.adriansrj.cv.api.CraftyVehiclesPluginBase;
import es.outlook.adriansrj.cv.api.configuration.Configuration;
import es.outlook.adriansrj.cv.api.configuration.LangConfiguration;
import es.outlook.adriansrj.cv.api.handler.PlayerWrapperHandler;
import es.outlook.adriansrj.cv.api.handler.PluginHandler;
import es.outlook.adriansrj.cv.api.handler.VehicleHandler;
import es.outlook.adriansrj.cv.api.service.BlockInfoService;
import es.outlook.adriansrj.cv.api.service.PacketService;
import es.outlook.adriansrj.cv.api.service.Service;
import es.outlook.adriansrj.cv.api.service.TexturedHeadService;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CraftyVehicles {
    private static CraftyVehiclesPluginBase PLUGIN_INSTANCE;
    private static final Map<Class<? extends PluginHandler>, PluginHandler> HANDLER_MAP;
    private static final Map<Class<? extends Service>, Service> SERVICE_MAP;

    @NotNull
    public static CraftyVehiclesPluginBase getPlugin() {
        if (PLUGIN_INSTANCE == null) {
            throw new IllegalStateException("api not initialized");
        }
        return PLUGIN_INSTANCE;
    }

    public static void initalize(@NotNull CraftyVehiclesPluginBase plugin) {
        if (PLUGIN_INSTANCE != null) {
            throw new IllegalStateException("api already initialized");
        }
        PLUGIN_INSTANCE = plugin;
        Configuration.load(plugin);
        LangConfiguration.load(plugin);
    }

    public static void disable() {
        if (PLUGIN_INSTANCE == null) {
            return;
        }
        for (PluginHandler handler : HANDLER_MAP.values()) {
            handler.onPluginDisable();
        }
    }

    @Nullable
    public static <T extends PluginHandler> T getHandler(@NotNull Class<T> type) {
        return (T)((PluginHandler)type.cast(HANDLER_MAP.get(type)));
    }

    @NotNull
    public static PlayerWrapperHandler getPlayerWrapperHandler() {
        return CraftyVehicles.getVitalHandler(PlayerWrapperHandler.class);
    }

    @NotNull
    public static VehicleHandler getVehicleHandler() {
        return CraftyVehicles.getVitalHandler(VehicleHandler.class);
    }

    public static void registerHandler(@NotNull Class<? extends PluginHandler> type, @NotNull PluginHandler handler) {
        if (HANDLER_MAP.containsKey(type)) {
            throw new IllegalArgumentException("handler already registered");
        }
        HANDLER_MAP.put(type, handler);
    }

    @NotNull
    private static <T extends PluginHandler> T getVitalHandler(@NotNull Class<T> type) {
        T handler = CraftyVehicles.getHandler(type);
        if (handler == null) {
            throw new IllegalStateException("severe error: vital handler " + type.getSimpleName() + " couldn't be initialized");
        }
        return handler;
    }

    @Nullable
    public static <T extends Service> T getService(@NotNull Class<T> type) {
        return (T)((Service)type.cast(SERVICE_MAP.get(type)));
    }

    @NotNull
    public static BlockInfoService getBlockInfoService() {
        return CraftyVehicles.getVitalService(BlockInfoService.class);
    }

    @NotNull
    public static PacketService getPacketService() {
        return CraftyVehicles.getVitalService(PacketService.class);
    }

    @NotNull
    public static TexturedHeadService getTexturedHeadService() {
        return CraftyVehicles.getVitalService(TexturedHeadService.class);
    }

    public static void registerService(@NotNull Class<? extends Service> type, @NotNull Service service) {
        if (SERVICE_MAP.containsKey(type)) {
            throw new IllegalArgumentException("service already registered");
        }
        SERVICE_MAP.put(type, service);
    }

    @NotNull
    private static <T extends Service> T getVitalService(@NotNull Class<T> type) {
        T service = CraftyVehicles.getService(type);
        if (service == null) {
            throw new IllegalStateException("severe error: vital service " + type.getSimpleName() + " couldn't be initialized");
        }
        return service;
    }

    static {
        HANDLER_MAP = new HashMap<Class<? extends PluginHandler>, PluginHandler>();
        SERVICE_MAP = new HashMap<Class<? extends Service>, Service>();
    }
}

