/*
 * Decompiled with CFR 0.152.
 */
package fr.bramsou.yaml.core.configuration;

import fr.bramsou.yaml.api.configuration.ConfigurationException;
import fr.bramsou.yaml.api.configuration.YamlSection;
import fr.bramsou.yaml.api.configuration.dynamic.ConfigurationList;
import fr.bramsou.yaml.api.configuration.dynamic.ConfigurationPart;
import fr.bramsou.yaml.api.configuration.dynamic.annotation.ConfigurationHeader;
import fr.bramsou.yaml.api.configuration.dynamic.annotation.ConfigurationKeys;
import fr.bramsou.yaml.api.configuration.dynamic.annotation.ConfigurationPath;
import fr.bramsou.yaml.api.configuration.dynamic.annotation.ConfigurationReplacement;
import fr.bramsou.yaml.api.util.Reflection;
import fr.bramsou.yaml.core.configuration.Configuration;
import fr.bramsou.yaml.core.configuration.ConfigurationSection;
import fr.bramsou.yaml.core.configuration.comment.CommentNode;
import fr.bramsou.yaml.core.configuration.comment.CommentTree;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DynamicConfiguration
extends Configuration {
    private final Object instance;
    private final Map<String, String[]> comments = new HashMap<String, String[]>();
    private final String[] headers;
    private static final Pattern LIST_ENTRY_PATTERN = Pattern.compile("^(\\s*)-.+$");
    private static final Pattern SECTION_PATTERN = Pattern.compile("^(\\s*)[a-zA-Z0-9_-]+:$");
    private static final Pattern VALUE_PATTERN = Pattern.compile("^(\\s*)[a-zA-Z0-9_-]+: .+$");

    private static MatchResult matchResult(String line) {
        if (LIST_ENTRY_PATTERN.matcher(line).matches()) {
            return null;
        }
        Matcher matcher = SECTION_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.toMatchResult();
        }
        matcher = VALUE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.toMatchResult();
        }
        return null;
    }

    public DynamicConfiguration(Object instance, File file) {
        super(file);
        this.instance = instance;
        ConfigurationHeader header = instance.getClass().getDeclaredAnnotation(ConfigurationHeader.class);
        this.headers = header == null ? null : header.value();
    }

    @Override
    public void load() {
        super.load();
        this.loadFromInstance(null, this.instance, this, null);
    }

    public void save() {
        Throwable throwable;
        if (this.entries.isEmpty()) {
            return;
        }
        String dump = this.yaml.dump((Object)this.entries);
        StringBuilder values = new StringBuilder();
        if (this.headers != null) {
            for (String header : this.headers) {
                if (header.equals("")) {
                    values.append("\n");
                    continue;
                }
                values.append("# ").append(header).append("\n");
            }
        }
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new StringReader(dump));){
                String line;
                CommentNode node = null;
                while ((line = reader.readLine()) != null) {
                    int indent;
                    String[] comments;
                    MatchResult result = DynamicConfiguration.matchResult(line);
                    String path = line.trim().split(":")[0];
                    if (result != null && (comments = this.comments.get((node = CommentTree.getNode(node, path, indent = result.group(1).length())).getFullPath())) != null) {
                        String separator = node.getIndentSeparator();
                        for (String comment : comments) {
                            values.append(separator);
                            if (!comment.equals("")) {
                                values.append("# ").append(comment);
                            }
                            values.append("\n");
                        }
                    }
                    values.append(line).append("\n");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot save configuration file (" + this.file.getPath() + ")", (Throwable)e);
        }
        try {
            throwable = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                writer.write(values.toString());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot save configuration file (" + this.file.getPath() + ")", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadFromInstance(String parentPath, Object instance, YamlSection parent, ConfigurationReplacement replacement) {
        for (Class<?> superClass : this.getSuperClasses(instance)) {
            block1: for (Field field : superClass.getDeclaredFields()) {
                String commentPath;
                String fullPath;
                ConfigurationPath annotatedPath = field.getAnnotation(ConfigurationPath.class);
                ConfigurationKeys annotatedKeys = field.getAnnotation(ConfigurationKeys.class);
                ConfigurationReplacement annotatedReplacement = field.getAnnotation(ConfigurationReplacement.class);
                if (annotatedPath == null) continue;
                Reflection.setAccessible((Field)field);
                String path = annotatedPath.value();
                String annotatedCommentPath = annotatedPath.commentPath();
                if (parentPath == null) {
                    fullPath = path;
                    commentPath = annotatedCommentPath.equals("") ? path : annotatedCommentPath;
                } else {
                    fullPath = parentPath + "." + path;
                    commentPath = annotatedCommentPath.equals("") ? fullPath : parentPath + "." + path;
                }
                Object fieldValue = Reflection.get((Field)field, (Object)instance);
                String[] comments = annotatedPath.comments();
                if (comments != null) {
                    this.comments.put(commentPath, comments);
                }
                if (fieldValue instanceof ConfigurationPart) {
                    YamlSection section = parent.getSection(path);
                    ConfigurationPart part = (ConfigurationPart)fieldValue;
                    this.loadFromInstance(fullPath, part, section, annotatedReplacement);
                    part.loaded();
                    continue;
                }
                if (fieldValue instanceof ConfigurationList) {
                    String keyPath;
                    String[] defaultComments;
                    ConfigurationList list = (ConfigurationList)fieldValue;
                    YamlSection section = parent.getSection(path);
                    Map entries = section.getEntries();
                    String[] stringArray = defaultComments = annotatedKeys == null ? null : annotatedKeys.keyComments();
                    if (entries.isEmpty()) {
                        void var25_30;
                        String[] defaultKeys;
                        String[] stringArray2 = defaultKeys = annotatedKeys == null ? null : annotatedKeys.defaultKeys();
                        if (defaultKeys == null) continue;
                        boolean bl = false;
                        while (var25_30 < list.size()) {
                            ConfigurationSection keySection = new ConfigurationSection();
                            if (var25_30 >= defaultKeys.length) continue block1;
                            ConfigurationPart part = (ConfigurationPart)list.get((int)var25_30);
                            String keyName = defaultKeys[var25_30];
                            keyPath = fullPath + "." + keyName;
                            this.loadFromInstance(keyPath, part, keySection, annotatedReplacement);
                            part.setName(keyName);
                            part.loaded();
                            if (defaultComments != null) {
                                this.comments.put(keyPath, defaultComments);
                            }
                            section.set(keyName, (Object)keySection);
                            ++var25_30;
                        }
                        continue;
                    }
                    list.clear();
                    for (Map.Entry entry : entries.entrySet()) {
                        YamlSection keySection;
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (!(value instanceof YamlSection)) {
                            keySection = new ConfigurationSection();
                            entry.setValue(keySection);
                        } else {
                            keySection = (YamlSection)value;
                        }
                        keyPath = fullPath + "." + key;
                        if (defaultComments != null) {
                            this.comments.put(keyPath, defaultComments);
                        }
                        ConfigurationPart part = list.create(key);
                        this.loadFromInstance(keyPath, part, keySection, annotatedReplacement);
                        part.setName(key);
                        part.loaded();
                        list.add((Object)part);
                    }
                    continue;
                }
                ArrayList<String> configValue = parent.get(path, fieldValue);
                if (configValue instanceof String || configValue instanceof List) {
                    HashMap<String, String> replacementMap = new HashMap<String, String>();
                    boolean translateColorCodes = false;
                    char colorCode = '&';
                    char translateCode = '\u00a7';
                    if (annotatedReplacement != null) {
                        this.fillReplacement(replacementMap, annotatedReplacement, field);
                        translateColorCodes = annotatedReplacement.translateColorCodes();
                        colorCode = annotatedReplacement.colorCode();
                        translateCode = annotatedReplacement.translateCode();
                    }
                    if (replacement != null) {
                        this.fillReplacement(replacementMap, replacement, field);
                        translateColorCodes = replacement.translateColorCodes();
                        colorCode = replacement.colorCode();
                        translateCode = replacement.translateCode();
                    }
                    if (!replacementMap.isEmpty() || translateColorCodes) {
                        if (configValue instanceof String) {
                            configValue = this.replaceMessage((String)((Object)configValue), replacementMap, translateColorCodes, colorCode, translateCode);
                        } else {
                            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                            boolean isString = String.class.getName().equals(parameterizedType.getActualTypeArguments()[0].getTypeName());
                            if (isString) {
                                List currentList = configValue;
                                ArrayList<String> coloredList = new ArrayList<String>(currentList.size());
                                for (String string : currentList) {
                                    coloredList.add(this.replaceMessage(string, replacementMap, translateColorCodes, colorCode, translateCode));
                                }
                                configValue = coloredList;
                            }
                        }
                    }
                }
                Reflection.set((Field)field, (Object)instance, (Object)configValue);
            }
        }
    }

    private void fillReplacement(Map<String, String> map, ConfigurationReplacement replacement, Field field) {
        String[] values = replacement.values();
        String[] replacements = replacement.replacements();
        for (int i = 0; i < values.length; ++i) {
            try {
                map.put(values[i], replacements[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new ConfigurationException("Unable to load configuration due to a wrong replacement annotation (field: " + field.getName() + ")", (Throwable)e);
            }
        }
    }

    private String replaceMessage(String input, Map<String, String> replacements, boolean translateColorCodes, char colorCode, char translateCode) {
        String output = input;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            output = output.replaceAll(entry.getKey(), entry.getValue());
        }
        if (translateColorCodes) {
            output = this.translateAlternateColorCodes(colorCode, translateCode, output);
        }
        return output;
    }

    private List<Class<?>> getSuperClasses(Object instance) {
        LinkedList classes = new LinkedList();
        for (Class<?> superClass = instance.getClass(); superClass != null; superClass = superClass.getSuperclass()) {
            classes.addFirst(superClass);
        }
        return classes;
    }

    private String translateAlternateColorCodes(char altColorChar, char translateCode, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = translateCode;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }
}

