/*
 * Decompiled with CFR 0.152.
 */
package fr.bramsou.yaml.core.configuration;

import fr.bramsou.yaml.api.configuration.ConfigurationException;
import fr.bramsou.yaml.api.configuration.YamlConfiguration;
import fr.bramsou.yaml.api.configuration.YamlSection;
import fr.bramsou.yaml.core.configuration.ConfigurationSection;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public abstract class Configuration
extends ConfigurationSection
implements YamlConfiguration {
    protected final File file;
    protected final Yaml yaml;

    public Configuration(File file) {
        this.file = file;
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setAllowUnicode(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Representer representer = new Representer(options){
            {
                this.representers.put(ConfigurationSection.class, data -> this.represent(((YamlSection)data).getEntries()));
            }
        };
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)new Constructor(new LoaderOptions()), representer, options);
        if (!this.file.exists()) {
            if (this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void load() {
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));){
            Map map = (Map)this.yaml.load((InputStream)input);
            if (map == null) {
                return;
            }
            for (Map.Entry entry : map.entrySet()) {
                String path = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    ConfigurationSection section = new ConfigurationSection();
                    section.loadFromMap((Map)value);
                    this.entries.put(path, section);
                    continue;
                }
                this.entries.put(path, value);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot load configuration file (" + this.file.getPath() + ")", (Throwable)e);
        }
    }

    public File getFile() {
        return this.file;
    }
}

