/*
 * Decompiled with CFR 0.152.
 */
package fr.bramsou.yaml.core;

import fr.bramsou.yaml.api.YamlAPI;
import fr.bramsou.yaml.api.configuration.ConfigurationType;
import fr.bramsou.yaml.api.configuration.YamlConfiguration;
import fr.bramsou.yaml.api.configuration.dynamic.ConfigurationPart;
import fr.bramsou.yaml.api.configuration.dynamic.annotation.ConfigurationPath;
import fr.bramsou.yaml.api.configuration.dynamic.annotation.ConfigurationReplacement;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MyDynamicConfiguration {
    @ConfigurationPath(value="example-value", comments={"Here is an example value :)"})
    public String exampleValue = "Hi !";
    @ConfigurationPath(value="example-size")
    public int exampleSize = 451;
    @ConfigurationPath(value="replaced-value")
    @ConfigurationReplacement(values={"$"}, replacements={"S"})
    public String replacedValue = "&cHi ! $$$";
    @ConfigurationPath(value="sub-section", comments={"Here is my sub config section ! :)"})
    @ConfigurationReplacement
    public MyConfigurationSection subSection = new MyConfigurationSection();
    @ConfigurationPath(value="siann", comments={"Here is an example value :)"})
    public String siann = "Bg";

    public MyDynamicConfiguration() {
        File configFile = new File("config.yml");
        YamlConfiguration configuration = YamlAPI.INSTANCE.getConfigurationManager().loadConfiguration((Object)this, configFile, ConfigurationType.DYNAMIC);
        configuration.load();
        configuration.save();
    }

    private static class MyConfigurationSection
    extends ConfigurationPart {
        @ConfigurationPath(value="enabled")
        public boolean enabled = true;
        @ConfigurationPath(value="players")
        public List<String> players = new ArrayList<String>(Arrays.asList("Bramsou", "Ibrahim"));

        private MyConfigurationSection() {
        }
    }
}

