/*
 * Decompiled with CFR 0.152.
 */
package fr.bramsou.yaml.api.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface YamlSection {
    public <T> void set(String var1, T var2);

    public <T> T get(String var1, T var2);

    public YamlSection getSection(String var1);

    default public String getString(String path, String defaultValue) {
        return this.get(path, defaultValue);
    }

    default public boolean getBoolean(String path, boolean defaultValue) {
        return this.get(path, defaultValue);
    }

    default public int getInteger(String path, int defaultValue) {
        return this.get(path, defaultValue);
    }

    default public double getDouble(String path, double defaultValue) {
        return this.get(path, defaultValue);
    }

    default public float getFloat(String path, float defaultValue) {
        return this.get(path, Float.valueOf(defaultValue)).floatValue();
    }

    default public <T> List<T> getList(String path, List<T> defaultValue) {
        return this.get(path, defaultValue);
    }

    default public List<String> getStringList(String path, List<String> defaultValue) {
        return this.get(path, defaultValue);
    }

    default public List<String> getColoredList(String path, List<String> defaultValue) {
        List<String> list = this.getStringList(path, defaultValue);
        ArrayList<String> coloredList = new ArrayList<String>(list.size());
        for (String value : list) {
            coloredList.add(value.replaceAll("&", "\u00a7"));
        }
        return coloredList;
    }

    public Set<String> getKeys();

    public Map<String, Object> getEntries();
}

