/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.cibuild;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import pl.project13.core.cibuild.BuildServerDataProvider;
import pl.project13.core.log.LogInterface;

public class TeamCityBuildServerData
extends BuildServerDataProvider {
    private final Properties teamcitySystemProperties = new Properties();

    TeamCityBuildServerData(@Nonnull LogInterface log, @Nonnull Map<String, String> env) {
        super(log, env);
        if (TeamCityBuildServerData.isActiveServer(env)) {
            try {
                this.teamcitySystemProperties.load(new FileInputStream(env.get("TEAMCITY_BUILD_PROPERTIES_FILE")));
            }
            catch (IOException | NullPointerException e) {
                log.error("Failed to retrieve Teamcity properties file", e);
            }
        }
    }

    public static boolean isActiveServer(@Nonnull Map<String, String> env) {
        return env.containsKey("TEAMCITY_VERSION");
    }

    @Override
    void loadBuildNumber(@Nonnull Properties properties) {
        String buildNumber = this.env.getOrDefault("BUILD_NUMBER", "");
        String buildNumberUnique = this.teamcitySystemProperties.getProperty("teamcity.build.id", "");
        this.maybePut(properties, "build.number", () -> buildNumber);
        this.maybePut(properties, "build.number.unique", () -> buildNumberUnique);
    }

    @Override
    public String getBuildBranch() {
        String environmentBasedBranch = this.teamcitySystemProperties.getProperty("teamcity.build.branch");
        this.log.info(String.format("Using property file based branch name. teamcity.build.branch = %s", environmentBasedBranch));
        return environmentBasedBranch;
    }
}

