/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Properties;
import javax.annotation.Nonnull;
import nu.studer.java.util.OrderedProperties;
import pl.project13.core.CommitIdPropertiesOutputFormat;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.log.LogInterface;
import pl.project13.core.util.BuildFileChangeListener;
import pl.project13.core.util.GenericFileManager;

public class PropertiesFileGenerator {
    private LogInterface log;
    private BuildFileChangeListener buildFileChangeListener;
    private CommitIdPropertiesOutputFormat propertiesOutputFormat;
    private String prefixDot;
    private String projectName;

    public PropertiesFileGenerator(LogInterface log, BuildFileChangeListener buildFileChangeListener, CommitIdPropertiesOutputFormat propertiesOutputFormat, String prefixDot, String projectName) {
        this.log = log;
        this.buildFileChangeListener = buildFileChangeListener;
        this.propertiesOutputFormat = propertiesOutputFormat;
        this.prefixDot = prefixDot;
        this.projectName = projectName;
    }

    public void maybeGeneratePropertiesFile(@Nonnull Properties localProperties, File projectDir, File propsFile, Charset sourceCharset, boolean escapeUnicode) throws GitCommitIdExecutionException {
        File gitPropsFile = PropertiesFileGenerator.craftPropertiesOutputFile(projectDir, propsFile);
        boolean shouldGenerate = true;
        if (gitPropsFile.exists()) {
            try {
                Properties persistedProperties = GenericFileManager.readProperties(this.log, this.propertiesOutputFormat, gitPropsFile, sourceCharset, this.projectName);
                Properties propertiesCopy = (Properties)localProperties.clone();
                String buildTimeProperty = this.prefixDot + "build.time";
                propertiesCopy.setProperty(buildTimeProperty, "");
                persistedProperties.setProperty(buildTimeProperty, "");
                shouldGenerate = !propertiesCopy.equals(persistedProperties);
            }
            catch (GitCommitIdExecutionException e) {
                this.log.info(e.getMessage());
                shouldGenerate = true;
            }
        }
        if (shouldGenerate) {
            GenericFileManager.dumpProperties(this.log, this.propertiesOutputFormat, gitPropsFile, sourceCharset, escapeUnicode, this.projectName, localProperties);
            if (this.buildFileChangeListener != null) {
                this.buildFileChangeListener.changed(gitPropsFile);
            }
        } else {
            this.log.info(String.format("Properties file [%s] is up-to-date (for module %s)...", gitPropsFile.getAbsolutePath(), this.projectName));
        }
    }

    public static OrderedProperties createOrderedProperties() {
        return new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).withOrdering(Comparator.nullsLast(Comparator.naturalOrder())).build();
    }

    public static File craftPropertiesOutputFile(File projectDir, File propsFile) {
        File returnPath = propsFile.isAbsolute() ? propsFile : projectDir.toPath().resolve(propsFile.toPath()).toFile();
        return returnPath;
    }
}

