/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.utils;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.ConstructorParameterSupplier;
import com.freya02.botcommands.api.DynamicInstanceSupplier;
import com.freya02.botcommands.api.InstanceSupplier;
import com.freya02.botcommands.api.annotations.Dependency;
import com.freya02.botcommands.internal.BContextImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInstancer {
    @Nullable
    public static Object getMethodTarget(BContextImpl context, Method method) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        return ClassInstancer.instantiate(context, method.getDeclaringClass());
    }

    public static Object instantiate(BContextImpl context, Class<?> aClass) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Object oldInstance = context.getClassInstance(aClass);
        if (oldInstance != null) {
            return oldInstance;
        }
        Object instance = ClassInstancer.constructInstance(context, aClass);
        ClassInstancer.injectDependencies(context, instance);
        context.putClassInstance(aClass, instance);
        return instance;
    }

    @NotNull
    private static Object constructInstance(BContextImpl context, Class<?> aClass) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object instance;
        for (DynamicInstanceSupplier dynamicInstanceSupplier : context.getDynamicInstanceSuppliers()) {
            Object instance2 = dynamicInstanceSupplier.get(context, aClass);
            if (instance2 == null) continue;
            return instance2;
        }
        InstanceSupplier<?> instanceSupplier = context.getInstanceSupplier(aClass);
        if (instanceSupplier != null) {
            instance = instanceSupplier.get(context);
            if (instance == null) {
                throw new IllegalArgumentException("InstanceSupplier from " + instanceSupplier.getClass() + " of " + aClass + " returned null");
            }
        } else {
            Constructor<?>[] constructors = aClass.getConstructors();
            if (constructors.length == 0) {
                throw new IllegalArgumentException("Class " + aClass.getName() + " must have an accessible constructor");
            }
            if (constructors.length > 1) {
                throw new IllegalArgumentException("Class " + aClass.getName() + " must have exactly one constructor");
            }
            Constructor<?> constructor = constructors[0];
            ArrayList<Object> parameterObjs = new ArrayList<Object>();
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int parameterTypesLength = parameterTypes.length;
            for (int i = 0; i < parameterTypesLength; ++i) {
                Class<?> parameterType = parameterTypes[i];
                if (BContext.class.isAssignableFrom(parameterType)) {
                    parameterObjs.add(context);
                    continue;
                }
                if (aClass.isMemberClass()) {
                    Object classInstance = context.getClassInstance(parameterType);
                    if (classInstance == null) {
                        throw new IllegalStateException("Found no class instance of %s for inner class %s".formatted(parameterType.getSimpleName(), aClass.getSimpleName()));
                    }
                    parameterObjs.add(classInstance);
                    continue;
                }
                ConstructorParameterSupplier<?> supplier = context.getParameterSupplier(parameterType);
                if (supplier == null) {
                    throw new IllegalArgumentException(String.format("Found no constructor parameter supplier for parameter #%d of type %s in class %s", i, parameterType.getSimpleName(), aClass.getSimpleName()));
                }
                parameterObjs.add(supplier.get(aClass));
            }
            instance = constructor.newInstance(parameterObjs.toArray());
        }
        return instance;
    }

    private static void injectDependencies(BContextImpl context, Object someCommand) throws IllegalAccessException {
        for (Field field : someCommand.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Dependency.class)) continue;
            if (!field.canAccess(someCommand) && !field.trySetAccessible()) {
                throw new IllegalArgumentException("Dependency field " + field + " is not accessible (make it public ?)");
            }
            Supplier<?> dependencySupplier = context.getCommandDependency(field.getType());
            if (dependencySupplier == null) {
                throw new IllegalArgumentException("Dependency supplier for field " + field + " was not set");
            }
            field.set(someCommand, dependencySupplier.get());
        }
    }
}

