/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.parameters.QuotableRegexParameterResolver;
import com.freya02.botcommands.api.prefixed.BaseCommandEvent;
import com.freya02.botcommands.api.prefixed.TextCommand;
import com.freya02.botcommands.api.prefixed.annotations.Category;
import com.freya02.botcommands.api.prefixed.annotations.Description;
import com.freya02.botcommands.internal.prefixed.TextCommandCandidates;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import com.freya02.botcommands.internal.prefixed.TextCommandParameter;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Utils {
    private static final Logger LOGGER = Logging.getLogger();

    public static String getParameterName(Parameter parameter, String defaultName) {
        if (parameter.isNamePresent()) {
            return parameter.getName();
        }
        return defaultName;
    }

    @Nullable
    public static String getDescription(@NotNull TextCommandInfo info) {
        Description classDescription = info.getMethod().getDeclaringClass().getAnnotation(Description.class);
        if (classDescription != null) {
            return classDescription.value();
        }
        if (!info.getDescription().isBlank()) {
            return info.getDescription();
        }
        return null;
    }

    @NotNull
    public static String getNonBlankDescription(@NotNull TextCommandInfo info) {
        return Objects.requireNonNullElse(Utils.getDescription(info), "No description");
    }

    public static String getCategory(@NotNull TextCommandInfo info) {
        Category category = info.getMethod().getDeclaringClass().getAnnotation(Category.class);
        if (category != null) {
            return category.value();
        }
        return "No category";
    }

    public static EmbedBuilder generateCommandHelp(TextCommandCandidates candidates, BaseCommandEvent event) {
        Consumer<EmbedBuilder> descConsumer;
        String subcommandHelp;
        MessageEmbed.AuthorInfo author;
        EmbedBuilder builder = event.getDefaultEmbed();
        TextCommandInfo commandInfo = (TextCommandInfo)candidates.last();
        String name = commandInfo.getPath().getFullPath();
        String description = Utils.getDescription(commandInfo);
        String prefix = event.getContext().getPrefix();
        MessageEmbed.AuthorInfo authorInfo = author = builder.isEmpty() ? null : event.getDefaultEmbed().build().getAuthor();
        if (author != null) {
            builder.setAuthor(author.getName() + " \u2013 '" + name + "' command", author.getUrl(), author.getIconUrl());
        } else {
            builder.setAuthor("'" + name + "' command");
        }
        if (description != null) {
            builder.addField("Description", description, false);
        }
        ArrayList<TextCommandInfo> reversedCandidates = new ArrayList<TextCommandInfo>(candidates);
        Collections.reverse(reversedCandidates);
        int i = 1;
        for (TextCommandInfo candidate : reversedCandidates) {
            String effectiveCandidateDescription;
            List<? extends TextCommandParameter> commandParameters = candidate.getOptionParameters();
            StringBuilder syntax = new StringBuilder("**Syntax**: " + prefix + name + " ");
            StringBuilder example = new StringBuilder("**Example**: " + prefix + name + " ");
            if (candidate.isRegexCommand()) {
                boolean needsQuote = Utils.hasMultipleQuotable(commandParameters);
                for (TextCommandParameter textCommandParameter : commandParameters) {
                    Class<?> boxedType = textCommandParameter.getBoxedType();
                    String argName = Utils.getArgName(needsQuote, textCommandParameter, boxedType);
                    String argExample = Utils.getArgExample(needsQuote, textCommandParameter, boxedType);
                    boolean isOptional = textCommandParameter.isOptional();
                    syntax.append(isOptional ? (char)'[' : '`').append(argName).append(isOptional ? (char)']' : '`').append(' ');
                    example.append(argExample).append(' ');
                }
            }
            String string = effectiveCandidateDescription = !candidate.hasDescription() ? "" : "**Description**: " + candidate.getDescription() + "\n";
            if (candidates.size() == 1) {
                builder.addField("Usage", effectiveCandidateDescription + syntax + "\n" + example, false);
            } else {
                builder.addField("Overload #" + i, effectiveCandidateDescription + syntax + "\n" + example, false);
            }
            ++i;
        }
        List<TextCommandCandidates> textSubcommands = event.getContext().findTextSubcommands(commandInfo.getPath());
        if (textSubcommands != null && !(subcommandHelp = textSubcommands.stream().map(TreeSet::first).map(info -> "**" + info.getPath().getNameAt(info.getPath().getNameCount() - commandInfo.getPath().getNameCount()) + "** : " + Utils.getNonBlankDescription(info)).collect(Collectors.joining("\n - "))).isBlank()) {
            builder.addField("Subcommands", subcommandHelp, false);
        }
        if ((descConsumer = ((TextCommand)commandInfo.getInstance()).getDetailedDescription()) != null) {
            descConsumer.accept(builder);
        }
        return builder;
    }

    private static String getArgExample(boolean needsQuote, TextCommandParameter parameter, Class<?> boxedType) {
        Optional<String> optionalExample = parameter.getData().getOptionalExample();
        if (optionalExample.isPresent()) {
            String argExampleStr = optionalExample.get();
            if (boxedType == String.class) {
                return needsQuote ? "\"" + argExampleStr + "\"" : argExampleStr;
            }
            return argExampleStr;
        }
        if (boxedType == String.class) {
            return needsQuote ? "\"foo bar\"" : "foo bar";
        }
        if (boxedType == Emoji.class) {
            return ":joy:";
        }
        if (boxedType == Integer.class) {
            return String.valueOf(ThreadLocalRandom.current().nextLong(50L));
        }
        if (boxedType == Long.class) {
            if (parameter.isId()) {
                return String.valueOf(ThreadLocalRandom.current().nextLong(100000000000000000L, 999999999999999999L));
            }
            return String.valueOf(ThreadLocalRandom.current().nextLong(50L));
        }
        if (boxedType == Float.class || boxedType == Double.class) {
            return String.valueOf(ThreadLocalRandom.current().nextDouble(50.0));
        }
        if (boxedType == Guild.class) {
            return "331718482485837825";
        }
        if (boxedType == Role.class) {
            return "801161492296499261";
        }
        if (boxedType == User.class) {
            return "222046562543468545";
        }
        if (boxedType == Member.class) {
            return "<@222046562543468545>";
        }
        if (boxedType == TextChannel.class) {
            return "331718482485837825";
        }
        return "?";
    }

    private static String getArgName(boolean needsQuote, TextCommandParameter commandParameter, Class<?> boxedType) {
        Optional<String> optionalName = commandParameter.getData().getOptionalName();
        if (optionalName.isPresent()) {
            String argNameStr = optionalName.get();
            if (boxedType == String.class) {
                return needsQuote ? "\"" + argNameStr + "\"" : argNameStr;
            }
            return argNameStr;
        }
        if (boxedType == String.class) {
            return needsQuote ? "\"" + Utils.getParameterName(commandParameter.getParameter(), "string") + "\"" : Utils.getParameterName(commandParameter.getParameter(), "string");
        }
        if (boxedType == Emoji.class) {
            return "unicode emoji/shortcode/emote/emote id";
        }
        if (boxedType == Integer.class) {
            return Utils.getParameterName(commandParameter.getParameter(), "integer");
        }
        if (boxedType == Long.class) {
            if (commandParameter.isId()) {
                return "Entity ID";
            }
            return Utils.getParameterName(commandParameter.getParameter(), "integer");
        }
        if (boxedType == Float.class || boxedType == Double.class) {
            return Utils.getParameterName(commandParameter.getParameter(), "decimal");
        }
        if (boxedType == Guild.class) {
            return "guild id";
        }
        if (boxedType == Role.class) {
            return "role mention/role id";
        }
        if (boxedType == User.class) {
            return "user mention/user id";
        }
        if (boxedType == Member.class) {
            return "member mention/member id";
        }
        if (boxedType == TextChannel.class) {
            return "text channel mention/text channel id";
        }
        LOGGER.warn("Unknown type: {}", boxedType);
        return "?";
    }

    public static boolean hasMultipleQuotable(List<? extends TextCommandParameter> optionParameters) {
        return optionParameters.stream().filter(p -> p.getResolver() instanceof QuotableRegexParameterResolver).count() > 1L;
    }

    @NotNull
    public static <T extends IMentionable> T findEntity(long id, @NotNull Collection<T> collection, Supplier<@NotNull T> valueSupplier) {
        for (IMentionable user : collection) {
            if (user.getIdLong() != id) continue;
            return (T)user;
        }
        return (T)((IMentionable)valueSupplier.get());
    }
}

