/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.prefixed;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.application.annotations.AppOption;
import com.freya02.botcommands.api.parameters.RegexParameterResolver;
import com.freya02.botcommands.api.prefixed.CommandEvent;
import com.freya02.botcommands.api.prefixed.TextCommand;
import com.freya02.botcommands.api.prefixed.annotations.JDATextCommand;
import com.freya02.botcommands.api.prefixed.annotations.TextOption;
import com.freya02.botcommands.internal.AbstractCommandInfo;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.NSFWState;
import com.freya02.botcommands.internal.prefixed.BaseCommandEventImpl;
import com.freya02.botcommands.internal.prefixed.CommandEventImpl;
import com.freya02.botcommands.internal.prefixed.CommandPattern;
import com.freya02.botcommands.internal.prefixed.ExecutionResult;
import com.freya02.botcommands.internal.prefixed.TextCommandParameter;
import com.freya02.botcommands.internal.utils.AnnotationUtils;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class TextCommandInfo
extends AbstractCommandInfo<TextCommand> {
    private static final Logger LOGGER = Logging.getLogger();
    private final List<CommandPath> aliases;
    private final String description;
    private final NSFWState nsfwState;
    private final boolean hidden;
    private final MethodParameters<TextCommandParameter> parameters;
    private final Pattern completePattern;
    private final int order;

    public TextCommandInfo(BContext context, TextCommand instance, Method commandMethod) {
        super(context, instance, commandMethod.getAnnotation(JDATextCommand.class), commandMethod, JDATextCommand::name, JDATextCommand::group, JDATextCommand::subcommand);
        JDATextCommand jdaCommand = commandMethod.getAnnotation(JDATextCommand.class);
        this.aliases = Arrays.stream(jdaCommand.aliases()).map(CommandPath::of).collect(Collectors.toList());
        this.description = jdaCommand.description();
        this.nsfwState = NSFWState.ofMethod(commandMethod);
        this.order = jdaCommand.order();
        boolean isRegexMethod = !ReflectionUtils.hasFirstParameter(commandMethod, CommandEvent.class);
        this.parameters = MethodParameters.of(context, commandMethod, (parameter, index) -> {
            if (parameter.isAnnotationPresent(AppOption.class)) {
                throw new IllegalArgumentException(String.format("Text command parameter #%d of %s#%s cannot be annotated with @AppOption", index, commandMethod.getDeclaringClass().getName(), commandMethod.getName()));
            }
            if (parameter.isAnnotationPresent(TextOption.class) && !isRegexMethod) {
                throw new IllegalArgumentException("Fallback text commands (CommandEvent ones) cannot have parameters annotated with @TextOption");
            }
            return new TextCommandParameter(RegexParameterResolver.class, (Parameter)parameter, (int)index);
        });
        this.hidden = AnnotationUtils.getEffectiveHiddenState(commandMethod);
        this.completePattern = this.parameters.getOptionCount() > 0 ? CommandPattern.of(this) : null;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<CommandPath> getAliases() {
        return this.aliases;
    }

    public boolean hasDescription() {
        return !this.description.isBlank();
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public NSFWState getNSFWState() {
        return this.nsfwState;
    }

    public int getOrder() {
        return this.order;
    }

    @Nullable
    public Pattern getCompletePattern() {
        return this.completePattern;
    }

    @NotNull
    public MethodParameters<TextCommandParameter> getParameters() {
        return this.parameters;
    }

    @NotNull
    public List<? extends TextCommandParameter> getOptionParameters() {
        return super.getOptionParameters();
    }

    public ExecutionResult execute(final BContextImpl context, final MessageReceivedEvent event, final String args, Matcher matcher, Consumer<Throwable> throwableConsumer) throws Exception {
        ArrayList<Object> objects = new ArrayList<Object>(this.parameters.size() + 1){
            {
                super(initialCapacity);
                if (TextCommandInfo.this.isRegexCommand()) {
                    this.add(new BaseCommandEventImpl(context, TextCommandInfo.this.getMethod(), event, args));
                } else {
                    this.add(new CommandEventImpl(context, TextCommandInfo.this.getMethod(), event, args));
                }
            }
        };
        if (this.isRegexCommand()) {
            int groupIndex = 1;
            for (TextCommandParameter parameter : this.parameters) {
                if (parameter.isOption()) {
                    int found = 0;
                    int groupCount = parameter.getGroupCount();
                    String[] groups = new String[groupCount];
                    for (int j = 0; j < groupCount; ++j) {
                        groups[j] = matcher.group(groupIndex++);
                        if (groups[j] == null) continue;
                        ++found;
                    }
                    if (found == groupCount) {
                        Object resolved = ((RegexParameterResolver)parameter.getResolver()).resolve(context, this, event, groups);
                        if (resolved == null && !parameter.isOptional()) {
                            return ExecutionResult.CONTINUE;
                        }
                        objects.add(resolved);
                        continue;
                    }
                    if (!parameter.isOptional()) {
                        LOGGER.warn("Could not find parameter #{} in {} for input args {}", new Object[]{parameter.getIndex(), Utils.formatMethodShort(this.commandMethod), args});
                        return ExecutionResult.CONTINUE;
                    }
                    if (parameter.isPrimitive()) {
                        objects.add(0);
                        continue;
                    }
                    objects.add(null);
                    continue;
                }
                objects.add(parameter.getCustomResolver().resolve(context, this, (Event)event));
            }
        } else {
            for (TextCommandParameter parameter : this.parameters) {
                objects.add(parameter.getCustomResolver().resolve(context, this, (Event)event));
            }
        }
        this.applyCooldown(event);
        this.getMethodRunner().invoke(objects.toArray(), throwableConsumer);
        return ExecutionResult.OK;
    }

    public boolean isRegexCommand() {
        return this.getCompletePattern() != null;
    }
}

