/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.modals;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.modals.InternalModals;
import com.freya02.botcommands.internal.modals.ModalHandlerInfo;
import com.freya02.botcommands.internal.modals.ModalListener;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import org.slf4j.Logger;

public class ModalHandlersBuilder {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;

    public ModalHandlersBuilder(BContextImpl context) {
        this.context = context;
        InternalModals.setContext(context);
    }

    public void processHandler(Object autocompleteHandler, Method method) {
        try {
            if (!ReflectionUtils.hasFirstParameter(method, ModalInteractionEvent.class)) {
                throw new IllegalArgumentException("Modal handler at " + Utils.formatMethodShort(method) + " must have a " + ModalInteractionEvent.class.getSimpleName() + " event as first parameter");
            }
            ModalHandlerInfo handler = new ModalHandlerInfo(this.context, autocompleteHandler, method);
            this.context.getApplicationCommandsContext().addModalHandler(handler);
            LOGGER.debug("Adding modal handler '{}' for method {}", (Object)handler.getHandlerName(), (Object)Utils.formatMethodShort(method));
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while processing a modal handler at " + Utils.formatMethodShort(method), e);
        }
    }

    public void postProcess() {
        this.context.addEventListeners(new ModalListener(this.context));
    }
}

