/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.events;

import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.ExecutableInteractionInfo;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.application.CommandParameter;
import com.freya02.botcommands.internal.events.EventConsumer;
import com.freya02.botcommands.internal.events.EventListenerImpl;
import com.freya02.botcommands.internal.events.EventListenerParameter;
import com.freya02.botcommands.internal.runner.MethodRunner;
import com.freya02.botcommands.internal.utils.EventUtils;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EventListenersBuilder {
    private static final Logger LOGGER = Logging.getLogger();
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Map<Class<?>, List<Class<?>>> implementors = new HashMap();
    private final Map<Class<?>, List<EventConsumer>> eventListenersMap = new HashMap();
    private final BContextImpl context;

    public EventListenersBuilder(BContextImpl context) {
        this.context = context;
        this.implementors.putAll(EventListenersBuilder.getAllEventImplementors());
    }

    @NotNull
    private static Map<Class<?>, List<Class<?>>> getAllEventImplementors() {
        HashMap implementors = new HashMap();
        for (Method method : ListenerAdapter.class.getDeclaredMethods()) {
            Class<?> eventType;
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || method.getParameterCount() != 1 || !(eventType = method.getParameterTypes()[0]).getSimpleName().endsWith("Event")) continue;
            HashSet subtypes = new HashSet();
            EventListenersBuilder.populateEventSubtypes(subtypes, eventType);
            for (Class clazz : subtypes) {
                implementors.computeIfAbsent(clazz, x -> new ArrayList()).add(eventType);
            }
        }
        return implementors;
    }

    private static void populateEventSubtypes(Set<Class<?>> subtypesList, Class<?> eventType) {
        if (!Event.class.isAssignableFrom(eventType)) {
            return;
        }
        subtypesList.add(eventType);
        EventListenersBuilder.populateEventSubtypes(subtypesList, eventType.getSuperclass());
        for (Class<?> superInterface : eventType.getInterfaces()) {
            EventListenersBuilder.populateEventSubtypes(subtypesList, superInterface);
        }
    }

    public void processEventListener(Object eventListener, Method method) {
        try {
            if (!ReflectionUtils.hasFirstParameter(method, Event.class)) {
                throw new IllegalArgumentException("Event listener at " + Utils.formatMethodShort(method) + " must have a valid (extends Event) JDA event as first parameter");
            }
            Class<?> eventType = method.getParameterTypes()[0];
            EventUtils.checkEvent(this.context.getJDA(), this.context.getJDA().getGatewayIntents(), eventType);
            if (method.getParameterCount() > 1) {
                EventConsumer consumer = this.getParametrizedEventListener(eventListener, method);
                for (Class<?> eventSubtype : this.implementors.get(eventType)) {
                    this.getEventConsumers(eventSubtype).add(consumer);
                }
                LOGGER.debug("Added a parametrized {} listener for method {}", (Object)eventType.getSimpleName(), (Object)Utils.formatMethodShort(method));
            } else {
                EventConsumer consumer = this.getFastEventListener(eventListener, method, eventType);
                for (Class<?> eventSubtype : this.implementors.get(eventType)) {
                    this.getEventConsumers(eventSubtype).add(consumer);
                }
                LOGGER.debug("Added a fast {} listener for method {}", (Object)eventType.getSimpleName(), (Object)Utils.formatMethodShort(method));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while processing an event listener at " + Utils.formatMethodShort(method), e);
        }
    }

    @NotNull
    private List<EventConsumer> getEventConsumers(Class<?> eventType) {
        return this.eventListenersMap.computeIfAbsent(eventType, x -> new ArrayList());
    }

    @NotNull
    private EventConsumer getParametrizedEventListener(Object eventListener, Method method) {
        MethodParameters<EventListenerParameter> parameters = MethodParameters.of(this.context, method, EventListenerParameter::new);
        MethodRunner methodRunner = this.context.getMethodRunnerFactory().make(eventListener, method);
        EventListenerExecutableInteractionInfo executableInteractionInfo = new EventListenerExecutableInteractionInfo(method, methodRunner, parameters, eventListener);
        return event -> {
            ArrayList<Object> objects = new ArrayList<Object>(parameters.size() + 1);
            objects.add(event);
            for (EventListenerParameter parameter : parameters) {
                Object obj = parameter.getCustomResolver().resolve(this.context, executableInteractionInfo, event);
                objects.add(obj);
            }
            methodRunner.invoke(objects.toArray(), EventListenersBuilder.getThrowableConsumer(this.context, event));
        };
    }

    public static Consumer<Throwable> getThrowableConsumer(BContextImpl context, Event event) {
        return e -> {
            ExceptionHandler handler = context.getUncaughtExceptionHandler();
            if (handler != null) {
                handler.onException(context, event, (Throwable)e);
                return;
            }
            Throwable baseEx = Utils.getException(e);
            Utils.printExceptionString("Unhandled exception in thread '" + Thread.currentThread().getName() + "' while executing an event", baseEx);
            context.dispatchException("Exception in component callback", baseEx);
        };
    }

    @NotNull
    private EventConsumer getFastEventListener(Object eventListener, Method method, Class<?> eventType) {
        String methodName = method.getName();
        try {
            MethodHandle handle = lookup.findVirtual(eventListener.getClass(), methodName, MethodType.methodType(Void.TYPE, eventType));
            CallSite site = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(EventConsumer.class, eventListener.getClass()), MethodType.methodType(Void.TYPE, Event.class), handle, MethodType.methodType(Void.TYPE, eventType));
            MethodHandle factory = site.getTarget();
            return factory.invoke(eventListener);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to generate an EventConsumer for handler method name '" + methodName + "' and type " + eventType, e);
        }
    }

    public void postProcess() {
        this.context.addEventListeners(new EventListenerImpl(this.context, this.eventListenersMap));
    }

    private record EventListenerExecutableInteractionInfo(Method method, MethodRunner methodRunner, MethodParameters<EventListenerParameter> parameters, Object eventListener) implements ExecutableInteractionInfo
    {
        @Override
        @NotNull
        public Method getMethod() {
            return this.method;
        }

        @Override
        @NotNull
        public MethodRunner getMethodRunner() {
            return this.methodRunner;
        }

        @Override
        @NotNull
        public MethodParameters<? extends CommandParameter<?>> getParameters() {
            return this.parameters;
        }

        @Override
        @NotNull
        public Object getInstance() {
            return this.eventListener;
        }
    }
}

