/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.events;

import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.events.EventConsumer;
import com.freya02.botcommands.internal.events.EventListenersBuilder;
import com.freya02.botcommands.internal.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

class EventListenerImpl
implements EventListener {
    private final BContextImpl context;
    private final Map<Class<?>, List<EventConsumer>> eventListeners;
    private int eventThreadNumber;
    private final ExecutorService eventExecutor = Utils.createCommandPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in an event executor thread '" + t.getName() + "':", e));
        thread.setName("Event executor thread #" + this.eventThreadNumber++);
        return thread;
    });

    EventListenerImpl(BContextImpl context, Map<Class<?>, List<EventConsumer>> eventListeners) {
        this.context = context;
        this.eventListeners = eventListeners;
    }

    private void runCallback(EventConsumer consumer, Event event, Consumer<Throwable> throwableConsumer) {
        this.eventExecutor.execute(() -> {
            try {
                consumer.accept(event);
            }
            catch (Throwable e) {
                throwableConsumer.accept(e);
            }
        });
    }

    @SubscribeEvent
    public void onEvent(@NotNull GenericEvent event) {
        if (!(event instanceof Event)) {
            return;
        }
        Event realEvent = (Event)event;
        List<EventConsumer> eventConsumers = this.eventListeners.get(event.getClass());
        if (eventConsumers != null) {
            Consumer<Throwable> throwableConsumer = EventListenersBuilder.getThrowableConsumer(this.context, realEvent);
            for (EventConsumer consumer : eventConsumers) {
                this.runCallback(consumer, realEvent, throwableConsumer);
            }
        }
    }
}

