/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.components.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.freya02.botcommands.api.components.ComponentType;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.components.builder.PersistentComponentTimeoutInfo;
import com.freya02.botcommands.internal.components.sql.SQLComponentData;
import com.freya02.botcommands.internal.components.sql.SQLFetchedComponent;
import com.freya02.botcommands.internal.utils.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SQLPersistentComponentData
extends SQLComponentData {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String handlerName;
    private final String[] args;

    private SQLPersistentComponentData(String componentId, long groupId, boolean oneUse, InteractionConstraints interactionConstraints, long expirationTimestamp, String handlerName, String[] args) {
        super(componentId, groupId, oneUse, interactionConstraints, expirationTimestamp);
        this.handlerName = handlerName;
        this.args = args;
    }

    private static String writeStringArray(String[] strings) {
        try {
            return MAPPER.writeValueAsString((Object)strings);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to serialize data: " + Arrays.toString(strings), e);
        }
    }

    private static String[] readStringArray(String json) {
        try {
            return (String[])MAPPER.readValue(json, String[].class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to deserialize data: " + json, e);
        }
    }

    @NotNull
    public static SQLPersistentComponentData fromFetchedComponent(@NotNull SQLFetchedComponent fetchedComponent) throws SQLException {
        ResultSet resultSet = fetchedComponent.getResultSet();
        return SQLPersistentComponentData.fromResult(resultSet);
    }

    @NotNull
    private static SQLPersistentComponentData fromResult(ResultSet resultSet) throws SQLException {
        return new SQLPersistentComponentData(resultSet.getString("componentId"), resultSet.getLong("groupId"), resultSet.getBoolean("oneUse"), InteractionConstraints.fromJson(resultSet.getString("constraints")), resultSet.getLong("expirationTimestamp"), resultSet.getString("handlerName"), SQLPersistentComponentData.readStringArray(resultSet.getString("args")));
    }

    @Nullable
    public static SQLPersistentComponentData read(Connection con, String componentId) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement("select * from persistentcomponentdata join componentdata using(componentid) where componentid = ?");){
            SQLPersistentComponentData sQLPersistentComponentData;
            block16: {
                ResultSet resultSet;
                block14: {
                    SQLPersistentComponentData sQLPersistentComponentData2;
                    block15: {
                        preparedStatement.setString(1, componentId);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block14;
                            sQLPersistentComponentData2 = SQLPersistentComponentData.fromResult(resultSet);
                            if (resultSet == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return sQLPersistentComponentData2;
                }
                sQLPersistentComponentData = null;
                if (resultSet == null) break block16;
                resultSet.close();
            }
            return sQLPersistentComponentData;
        }
    }

    public static String create(Connection con, ComponentType type, boolean oneUse, InteractionConstraints constraints, PersistentComponentTimeoutInfo timeout, String handlerName, String[] args) throws SQLException {
        SQLException lastEx = null;
        int i = 0;
        while (i < 10) {
            String string;
            block9: {
                long timeoutMillis = timeout.toMillis();
                String randomId = Utils.randomId(64);
                PreparedStatement preparedStatement = con.prepareStatement("insert into componentdata (type, componentid, oneuse, constraints, expirationtimestamp) values (?, ?, ?, ?, ?);\ninsert into persistentcomponentdata (componentid, handlername, args) values (?, ?, ?);");
                try {
                    preparedStatement.setInt(1, type.getKey());
                    preparedStatement.setString(2, randomId);
                    preparedStatement.setBoolean(3, oneUse);
                    preparedStatement.setString(4, constraints.toJson());
                    preparedStatement.setLong(5, timeoutMillis == 0L ? 0L : System.currentTimeMillis() + timeoutMillis);
                    preparedStatement.setString(6, randomId);
                    preparedStatement.setString(7, handlerName);
                    preparedStatement.setString(8, SQLPersistentComponentData.writeStringArray(args));
                    preparedStatement.execute();
                    string = randomId;
                    if (preparedStatement == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        lastEx = ex;
                        ++i;
                    }
                }
                preparedStatement.close();
            }
            return string;
        }
        throw new SQLException("Could not insert a random component ID after 10 tries, maybe the database is full of IDs ?", lastEx);
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public String[] getArgs() {
        return this.args;
    }

    @Override
    public String toString() {
        return "SqlPersistentComponentData{handlerName='" + this.handlerName + "', args=" + Arrays.toString(this.args) + "} " + super.toString();
    }
}

