/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.components;

import com.freya02.botcommands.api.components.ComponentListener;
import com.freya02.botcommands.api.components.annotations.JDAButtonListener;
import com.freya02.botcommands.api.components.annotations.JDASelectionMenuListener;
import com.freya02.botcommands.api.components.event.ButtonEvent;
import com.freya02.botcommands.api.components.event.EntitySelectionEvent;
import com.freya02.botcommands.api.components.event.StringSelectionEvent;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.components.ComponentDescriptor;
import com.freya02.botcommands.internal.utils.ClassInstancer;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ComponentsBuilder {
    private final Map<String, ComponentDescriptor> buttonsMap = new HashMap<String, ComponentDescriptor>();
    private final Map<String, ComponentDescriptor> selectionMenuMap = new HashMap<String, ComponentDescriptor>();
    private final BContextImpl context;

    public ComponentsBuilder(BContextImpl context) {
        this.context = context;
    }

    public void processClass(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            JDAButtonListener jdaButtonListener = method.getAnnotation(JDAButtonListener.class);
            if (jdaButtonListener != null) {
                this.handleComponentListener(method, jdaButtonListener.name(), this.buttonsMap, ButtonEvent.class, "Button listener");
                continue;
            }
            JDASelectionMenuListener jdaStringSelectMenuListener = method.getAnnotation(JDASelectionMenuListener.class);
            if (jdaStringSelectMenuListener == null) continue;
            if (ReflectionUtils.hasFirstParameter(method, StringSelectionEvent.class)) {
                this.handleComponentListener(method, jdaStringSelectMenuListener.name(), this.selectionMenuMap, StringSelectionEvent.class, "String selection menu");
                continue;
            }
            if (ReflectionUtils.hasFirstParameter(method, EntitySelectionEvent.class)) {
                this.handleComponentListener(method, jdaStringSelectMenuListener.name(), this.selectionMenuMap, EntitySelectionEvent.class, "Entity selection menu");
                continue;
            }
            throw new IllegalArgumentException("First parameter of method %s should be either a %s or %s".formatted(Utils.formatMethodShort(method), StringSelectionEvent.class.getSimpleName(), EntitySelectionEvent.class.getSimpleName()));
        }
    }

    private void handleComponentListener(Method method, String handlerName, Map<String, ComponentDescriptor> map, Class<?> firstRequiredArg, String componentType) {
        if (!ReflectionUtils.hasFirstParameter(method, firstRequiredArg)) {
            throw new IllegalArgumentException("First parameter of method " + Utils.formatMethodShort(method) + " should be a " + firstRequiredArg.getSimpleName());
        }
        try {
            Object obj = ClassInstancer.getMethodTarget(this.context, method);
            if (!method.canAccess(obj)) {
                throw new IllegalStateException(componentType + " " + Utils.formatMethodShort(method) + " is not public");
            }
            ComponentDescriptor newDescriptor = new ComponentDescriptor(this.context, obj, method);
            ComponentDescriptor oldVal = map.put(handlerName, newDescriptor);
            if (oldVal != null) {
                throw new IllegalStateException(componentType + " with name " + handlerName + " in " + Utils.formatMethodShort(method) + " was already registered as " + oldVal.getMethod());
            }
            this.context.getRegistrationListeners().forEach(l -> l.onComponentRegistered(newDescriptor));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("An error occurred while instantiating the class of the " + componentType + "'s method " + Utils.formatMethodShort(method), e);
        }
    }

    public void postProcess() {
        this.context.addEventListeners(new Object[]{new ComponentListener(this.context, this.buttonsMap, this.selectionMenuMap)});
    }
}

