/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.slash.autocomplete.caches;

import com.freya02.botcommands.api.application.slash.autocomplete.annotations.CacheAutocompletion;
import com.freya02.botcommands.internal.ConsumerEx;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompletionHandlerInfo;
import com.freya02.botcommands.internal.application.slash.autocomplete.CompositeAutocompletionKey;
import com.freya02.botcommands.internal.application.slash.autocomplete.caches.BaseAutocompletionCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.function.Consumer;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.interactions.commands.Command;
import org.jetbrains.annotations.NotNull;

public class ConstantByKeyAutocompletionCache
extends BaseAutocompletionCache {
    private final AutocompletionHandlerInfo handlerInfo;
    private final Cache<CompositeAutocompletionKey, List<Command.Choice>> cache;

    public ConstantByKeyAutocompletionCache(AutocompletionHandlerInfo handlerInfo, @NotNull CacheAutocompletion cacheAutocompletion) {
        super(cacheAutocompletion);
        this.handlerInfo = handlerInfo;
        this.cache = Caffeine.newBuilder().maximumWeight(cacheAutocompletion.cacheSize() * 1024L).weigher(this::getEntrySize).build();
    }

    private int getEntrySize(Object k, Object v) {
        int sum = ((CompositeAutocompletionKey)k).length();
        List choices = (List)v;
        for (Command.Choice c : choices) {
            sum += c.getName().length() + c.getAsString().length();
        }
        return sum;
    }

    @Override
    public void retrieveAndCall(CommandAutoCompleteInteractionEvent event, Consumer<List<Command.Choice>> choiceCallback, ConsumerEx<CompositeAutocompletionKey> valueComputer) throws Exception {
        CompositeAutocompletionKey compositeKey = this.getCompositeKey(this.handlerInfo, event);
        List cachedValue = (List)this.cache.getIfPresent((Object)compositeKey);
        if (cachedValue != null) {
            choiceCallback.accept(cachedValue);
        } else {
            valueComputer.accept(compositeKey);
        }
    }

    @Override
    public void put(CompositeAutocompletionKey key, List<Command.Choice> choices) {
        this.cache.put((Object)key, choices);
    }

    @Override
    public void invalidate() {
        this.cache.invalidateAll();
    }
}

