/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application.slash.autocomplete;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.internal.ApplicationOptionData;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashCommandParameter;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompletionHandlerInfo;
import com.freya02.botcommands.internal.application.slash.autocomplete.AutocompletionListener;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import org.slf4j.Logger;

public class AutocompletionHandlersBuilder {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;

    public AutocompletionHandlersBuilder(BContextImpl context) {
        this.context = context;
    }

    public void processHandler(Object autocompleteHandler, Method method) {
        try {
            if (!ReflectionUtils.hasFirstParameter(method, CommandAutoCompleteInteractionEvent.class)) {
                throw new IllegalArgumentException("Autocompletion handler at " + Utils.formatMethodShort(method) + " must have a " + CommandAutoCompleteInteractionEvent.class.getSimpleName() + " event as first parameter");
            }
            AutocompletionHandlerInfo handler = new AutocompletionHandlerInfo(this.context, autocompleteHandler, method);
            this.context.addAutocompletionHandler(handler);
            LOGGER.debug("Adding autocompletion handler '{}' for method {}", (Object)handler.getHandlerName(), (Object)Utils.formatMethodShort(method));
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while processing an autocompletion handler at " + Utils.formatMethodShort(method), e);
        }
    }

    public void postProcess() {
        for (SlashCommandInfo info : this.context.getApplicationCommandsContext().getApplicationCommandInfoMap().getSlashCommands().values()) {
            try {
                MethodParameters<SlashCommandParameter> parameters = info.getParameters();
                int parametersSize = parameters.size();
                for (int i = 0; i < parametersSize; ++i) {
                    ApplicationOptionData applicationOptionData;
                    String autocompleteHandlerName;
                    SlashCommandParameter parameter = (SlashCommandParameter)parameters.get(i);
                    if (!parameter.isOption() || (autocompleteHandlerName = (applicationOptionData = parameter.getApplicationOptionData()).getAutocompletionHandlerName()) == null) continue;
                    AutocompletionHandlerInfo handler = this.context.getAutocompletionHandler(autocompleteHandlerName);
                    if (handler == null) {
                        throw new IllegalArgumentException("Slash command parameter #" + i + " at " + Utils.formatMethodShort(info.getMethod()) + " uses autocompletion but has no handler assigned, did you misspell the handler name ? Consider using a constant variable to share with the handler and the option");
                    }
                    handler.checkParameters(info);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("An exception occurred while checking autocomplete handlers of slash command at " + Utils.formatMethodShort(info.getMethod()), e);
            }
        }
        this.context.addEventListeners(new AutocompletionListener(this.context));
    }
}

