/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.application.CommandScope;
import com.freya02.botcommands.api.builder.DebugBuilder;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.application.ApplicationCommandDataMap;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.application.ApplicationCommandsCache;
import com.freya02.botcommands.internal.application.CommandIdProcessor;
import com.freya02.botcommands.internal.application.context.message.MessageCommandInfo;
import com.freya02.botcommands.internal.application.context.user.UserCommandInfo;
import com.freya02.botcommands.internal.application.localization.BCLocalizationFunction;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandGroupData;
import net.dv8tion.jda.api.interactions.commands.localization.LocalizationFunction;
import net.dv8tion.jda.api.requests.restaction.CommandListUpdateAction;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ApplicationCommandsUpdater {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context;
    @Nullable
    private final Guild guild;
    private final boolean onlineCheck;
    private final Path commandsCachePath;
    private final ApplicationCommandDataMap map = new ApplicationCommandDataMap();
    private final Map<String, SubcommandGroupData> subcommandGroupDataMap = new HashMap<String, SubcommandGroupData>();
    private final List<ApplicationCommandInfo> updatableApplicationCommands;
    private final List<Command> commands = new ArrayList<Command>();
    private final Collection<CommandData> allCommandData;

    private ApplicationCommandsUpdater(@NotNull BContextImpl context, @Nullable Guild guild, boolean onlineCheck) throws IOException {
        this.context = context;
        this.guild = guild;
        this.onlineCheck = onlineCheck;
        this.commandsCachePath = guild == null ? context.getApplicationCommandsCache().getGlobalCommandsPath() : context.getApplicationCommandsCache().getGuildCommandsPath(guild);
        Files.createDirectories(this.commandsCachePath.getParent(), new FileAttribute[0]);
        CommandIdProcessor commandIdProcessor = guild == null ? null : new CommandIdProcessor(context);
        this.updatableApplicationCommands = this.context.getApplicationCommandsContext().getApplicationCommandInfoMap().filterByGuild(this.context, this.guild, commandIdProcessor);
        this.computeCommands();
        this.allCommandData = this.map.getAllCommandData();
        BCLocalizationFunction localizationFunction = new BCLocalizationFunction(context);
        for (CommandData commandData : this.allCommandData) {
            commandData.setLocalizationFunction((LocalizationFunction)localizationFunction);
        }
    }

    public static ApplicationCommandsUpdater ofGlobal(@NotNull BContextImpl context, boolean onlineCheck) throws IOException {
        return new ApplicationCommandsUpdater(context, null, onlineCheck);
    }

    public static ApplicationCommandsUpdater ofGuild(@NotNull BContextImpl context, @NotNull Guild guild, boolean onlineCheck) throws IOException {
        return new ApplicationCommandsUpdater(context, guild, onlineCheck);
    }

    public List<ApplicationCommandInfo> getScopeApplicationCommands() {
        if (this.guild != null) {
            ArrayList<ApplicationCommandInfo> list = new ArrayList<ApplicationCommandInfo>(this.updatableApplicationCommands);
            list.addAll(this.context.getApplicationCommandsContext().getApplicationCommandInfoMap().filterByGuild(this.context, null, null));
            return list;
        }
        return this.updatableApplicationCommands;
    }

    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    @Blocking
    public boolean shouldUpdateCommands() throws IOException {
        boolean needUpdate;
        byte[] oldBytes;
        if (this.onlineCheck) {
            this.commands.clear();
            this.commands.addAll((Collection)(this.guild == null ? this.context.getJDA().retrieveCommands(true) : this.guild.retrieveCommands(true)).complete());
            List<CommandData> discordCommandsData = this.commands.stream().map(CommandData::fromCommand).toList();
            oldBytes = ApplicationCommandsCache.getCommandsBytes(discordCommandsData);
        } else {
            if (Files.notExists(this.commandsCachePath, new LinkOption[0])) {
                LOGGER.trace("Updating commands because cache file does not exists");
                return true;
            }
            oldBytes = Files.readAllBytes(this.commandsCachePath);
        }
        byte[] newBytes = ApplicationCommandsCache.getCommandsBytes(this.allCommandData);
        boolean bl = needUpdate = !ApplicationCommandsCache.isJsonContentSame(oldBytes, newBytes);
        if (needUpdate) {
            LOGGER.trace("Updating commands because content is not equal");
            if (DebugBuilder.isLogApplicationDiffsEnabled()) {
                LOGGER.trace("Old commands bytes: {}", (Object)new String(oldBytes));
                LOGGER.trace("New commands bytes: {}", (Object)new String(newBytes));
            }
        }
        return needUpdate;
    }

    @Blocking
    public void updateCommands() {
        CommandListUpdateAction updateAction = this.guild != null ? this.guild.updateCommands() : this.context.getJDA().updateCommands();
        List commands = (List)updateAction.addCommands(this.allCommandData).complete();
        if (this.guild != null) {
            this.thenAcceptGuild(commands, this.guild);
        } else {
            this.thenAcceptGlobal(commands);
        }
    }

    private void computeCommands() {
        this.computeSlashCommands(this.updatableApplicationCommands);
        this.computeContextCommands(this.updatableApplicationCommands, UserCommandInfo.class, Command.Type.USER);
        this.computeContextCommands(this.updatableApplicationCommands, MessageCommandInfo.class, Command.Type.MESSAGE);
    }

    private void computeSlashCommands(List<ApplicationCommandInfo> guildApplicationCommands) {
        guildApplicationCommands.stream().filter(a -> a instanceof SlashCommandInfo).map(a -> (SlashCommandInfo)a).forEachOrdered(info -> {
            block5: {
                CommandPath commandPath = info.getPath();
                String description = info.getDescription();
                try {
                    List<OptionData> methodOptions = SlashUtils.getMethodOptions(this.context, this.guild, info);
                    if (commandPath.getNameCount() == 1) {
                        SlashCommandData rightCommand = Commands.slash((String)commandPath.getName(), (String)description);
                        this.map.put(Command.Type.SLASH, commandPath, (CommandData)rightCommand);
                        rightCommand.addOptions(methodOptions);
                        this.configureTopLevel((ApplicationCommandInfo)info, (CommandData)rightCommand);
                        break block5;
                    }
                    if (commandPath.getNameCount() == 2) {
                        Checks.notNull((Object)commandPath.getSubname(), (String)"Subcommand name");
                        SlashCommandData commandData = (SlashCommandData)this.map.computeIfAbsent(Command.Type.SLASH, commandPath, x -> {
                            SlashCommandData tmpData = Commands.slash((String)commandPath.getName(), (String)"No description (base name)");
                            this.configureTopLevel((ApplicationCommandInfo)info, (CommandData)tmpData);
                            return tmpData;
                        });
                        SubcommandData subcommandData = new SubcommandData(commandPath.getSubname(), description);
                        subcommandData.addOptions(methodOptions);
                        commandData.addSubcommands(new SubcommandData[]{subcommandData});
                        break block5;
                    }
                    if (commandPath.getNameCount() == 3) {
                        Checks.notNull((Object)commandPath.getGroup(), (String)"Command group name");
                        Checks.notNull((Object)commandPath.getSubname(), (String)"Subcommand name");
                        SubcommandGroupData groupData = this.getSubcommandGroup(Command.Type.SLASH, commandPath, x -> {
                            SlashCommandData commandData = Commands.slash((String)commandPath.getName(), (String)"No description (base name)");
                            this.configureTopLevel((ApplicationCommandInfo)info, (CommandData)commandData);
                            return commandData;
                        });
                        SubcommandData subcommandData = new SubcommandData(commandPath.getSubname(), description);
                        subcommandData.addOptions(methodOptions);
                        groupData.addSubcommands(new SubcommandData[]{subcommandData});
                        break block5;
                    }
                    throw new IllegalStateException("A slash command with more than 4 path components got registered");
                }
                catch (Exception e) {
                    throw new RuntimeException("An exception occurred while processing command '" + commandPath + "' at " + Utils.formatMethodShort(info.getMethod()), e);
                }
            }
        });
    }

    private <T extends ApplicationCommandInfo> void computeContextCommands(List<ApplicationCommandInfo> guildApplicationCommands, Class<T> targetClazz, Command.Type type) {
        guildApplicationCommands.stream().filter(a -> targetClazz.isAssignableFrom(a.getClass())).map(a -> a).forEachOrdered(info -> {
            CommandPath commandPath = info.getPath();
            try {
                if (commandPath.getNameCount() != 1) {
                    throw new IllegalStateException("A " + type.name() + " command with more than 1 path component got registered");
                }
                CommandData rightCommand = Commands.context((Command.Type)type, (String)commandPath.getName());
                this.map.put(type, commandPath, rightCommand);
                this.configureTopLevel((ApplicationCommandInfo)info, rightCommand);
            }
            catch (Exception e) {
                throw new RuntimeException("An exception occurred while processing a " + type.name() + " command " + commandPath, e);
            }
        });
    }

    private void configureTopLevel(ApplicationCommandInfo info, CommandData rightCommand) {
        rightCommand.setNSFW(info.isNsfw());
        if (info.isDefaultLocked()) {
            rightCommand.setDefaultPermissions(DefaultMemberPermissions.DISABLED);
        } else if (!info.getUserPermissions().isEmpty()) {
            rightCommand.setDefaultPermissions(DefaultMemberPermissions.enabledFor(info.getUserPermissions()));
        }
        if (info.getScope() == CommandScope.GLOBAL_NO_DM) {
            rightCommand.setGuildOnly(true);
        }
    }

    private void thenAcceptGuild(List<Command> commands, @NotNull Guild guild) {
        for (Command command : commands) {
            this.context.getRegistrationListeners().forEach(l -> l.onGuildSlashCommandRegistered(this.guild, command));
        }
        this.commands.clear();
        this.commands.addAll(commands);
        try {
            Files.write(this.commandsCachePath, ApplicationCommandsCache.getCommandsBytes(this.allCommandData), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("An exception occurred while temporarily saving guild ({} ({})) commands in '{}'", new Object[]{guild.getName(), guild.getId(), this.commandsCachePath.toAbsolutePath(), e});
        }
        if (!LOGGER.isTraceEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Updated " + commands.size() + " / " + this.allCommandData.size() + " (" + this.context.getApplicationCommandsView().size() + ") commands for ");
        sb.append(guild.getName()).append(" :\n");
        SlashUtils.appendCommands(commands, sb);
        LOGGER.trace(sb.toString().trim());
    }

    private void thenAcceptGlobal(List<Command> commands) {
        for (Command command : commands) {
            this.context.getRegistrationListeners().forEach(l -> l.onGlobalSlashCommandRegistered(command));
        }
        try {
            Files.write(this.commandsCachePath, ApplicationCommandsCache.getCommandsBytes(this.allCommandData), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("An exception occurred while temporarily saving {} commands in '{}'", new Object[]{this.guild == null ? "global" : String.format("guild '%s' (%s)", this.guild.getName(), this.guild.getId()), this.commandsCachePath.toAbsolutePath(), e});
        }
        if (!LOGGER.isTraceEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Updated global commands:\n");
        SlashUtils.appendCommands(commands, sb);
        LOGGER.trace(sb.toString().trim());
    }

    @NotNull
    private SubcommandGroupData getSubcommandGroup(Command.Type type, CommandPath path, Function<String, CommandData> baseCommandSupplier) {
        if (path.getGroup() == null) {
            throw new IllegalArgumentException("Group component of command path is null at '" + path + "'");
        }
        SlashCommandData data = (SlashCommandData)this.map.computeIfAbsent(type, path, baseCommandSupplier);
        CommandPath parent = path.getParent();
        if (parent == null) {
            throw new IllegalStateException("A command path with less than 3 components was passed to #getSubcommandGroup");
        }
        return this.subcommandGroupDataMap.computeIfAbsent(parent.getFullPath(), s -> {
            SubcommandGroupData groupData = new SubcommandGroupData(path.getGroup(), "No description (group)");
            data.addSubcommandGroups(new SubcommandGroupData[]{groupData});
            return groupData;
        });
    }
}

