/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.application.ApplicationCommandInfoMapView;
import com.freya02.botcommands.api.application.ApplicationCommandsContext;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.internal.AbstractCommandInfo;
import com.freya02.botcommands.internal.application.ApplicationCommandInfoMap;
import com.freya02.botcommands.internal.application.CommandInfoMap;
import com.freya02.botcommands.internal.application.context.message.MessageCommandInfo;
import com.freya02.botcommands.internal.application.context.user.UserCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.modals.ModalHandlerInfo;
import com.freya02.botcommands.internal.utils.Utils;
import gnu.trove.TCollections;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ApplicationCommandsContextImpl
implements ApplicationCommandsContext {
    private boolean forceGuildCommands;
    private final ApplicationCommandInfoMap applicationCommandInfoMap = new ApplicationCommandInfoMap();
    private final TLongObjectMap<ApplicationCommandInfoMapView> liveApplicationCommandInfoMap = TCollections.synchronizedMap((TLongObjectMap)new TLongObjectHashMap());
    private final Map<String, ModalHandlerInfo> modalHandlersMap = new HashMap<String, ModalHandlerInfo>();
    private final Map<String, List<Locale>> baseNameToLocalesMap = new HashMap<String, List<Locale>>();

    private long getGuildKey(@Nullable Guild guild) {
        return guild == null ? 0L : guild.getIdLong();
    }

    @Override
    @Nullable
    public SlashCommandInfo findLiveSlashCommand(@Nullable Guild guild, @NotNull CommandPath path) {
        ApplicationCommandInfoMapView view = (ApplicationCommandInfoMapView)this.liveApplicationCommandInfoMap.get(this.getGuildKey(guild));
        if (view == null) {
            return null;
        }
        return view.findSlashCommand(path);
    }

    @Override
    @Nullable
    public UserCommandInfo findLiveUserCommand(@Nullable Guild guild, @NotNull String name) {
        ApplicationCommandInfoMapView view = (ApplicationCommandInfoMapView)this.liveApplicationCommandInfoMap.get(this.getGuildKey(guild));
        if (view == null) {
            return null;
        }
        return view.findUserCommand(name);
    }

    @Override
    @Nullable
    public MessageCommandInfo findLiveMessageCommand(@Nullable Guild guild, @NotNull String name) {
        ApplicationCommandInfoMapView view = (ApplicationCommandInfoMapView)this.liveApplicationCommandInfoMap.get(this.getGuildKey(guild));
        if (view == null) {
            return null;
        }
        return view.findMessageCommand(name);
    }

    @NotNull
    public ApplicationCommandInfoMap getApplicationCommandInfoMap() {
        return this.applicationCommandInfoMap;
    }

    @Override
    @NotNull
    public @UnmodifiableView ApplicationCommandInfoMapView getApplicationCommandInfoMapView() {
        return this.applicationCommandInfoMap;
    }

    @NotNull
    public CommandInfoMap<SlashCommandInfo> getSlashCommandsMap() {
        return this.getApplicationCommandInfoMap().getSlashCommands();
    }

    @Override
    @NotNull
    public @UnmodifiableView CommandInfoMap<SlashCommandInfo> getSlashCommandsMapView() {
        return this.getApplicationCommandInfoMapView().getSlashCommandsView();
    }

    @NotNull
    public CommandInfoMap<UserCommandInfo> getUserCommandsMap() {
        return this.getApplicationCommandInfoMap().getUserCommands();
    }

    @Override
    @NotNull
    public @UnmodifiableView CommandInfoMap<UserCommandInfo> getUserCommandsMapView() {
        return this.getApplicationCommandInfoMapView().getUserCommandsView();
    }

    @NotNull
    public CommandInfoMap<MessageCommandInfo> getMessageCommandsMap() {
        return this.getApplicationCommandInfoMap().getMessageCommands();
    }

    @Override
    @NotNull
    public @UnmodifiableView CommandInfoMap<MessageCommandInfo> getMessageCommandsMapView() {
        return this.getApplicationCommandInfoMapView().getMessageCommandsView();
    }

    @Override
    public List<CommandPath> getSlashCommandsPaths() {
        return this.getSlashCommandsMap().values().stream().map(AbstractCommandInfo::getPath).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public ApplicationCommandInfoMapView getLiveApplicationCommandsMap(@Nullable Guild guild) {
        return (ApplicationCommandInfoMapView)this.liveApplicationCommandInfoMap.get(this.getGuildKey(guild));
    }

    @Override
    public boolean isForceGuildCommandsEnabled() {
        return this.forceGuildCommands;
    }

    public void setForceGuildCommands(boolean forceGuildCommands) {
        this.forceGuildCommands = forceGuildCommands;
    }

    public void putLiveApplicationCommandsMap(@Nullable Guild guild, @NotNull ApplicationCommandInfoMap map) {
        this.liveApplicationCommandInfoMap.put(this.getGuildKey(guild), (Object)map);
    }

    public void addModalHandler(ModalHandlerInfo handlerInfo) {
        ModalHandlerInfo oldHandler = this.modalHandlersMap.put(handlerInfo.getHandlerName(), handlerInfo);
        if (oldHandler != null) {
            throw new IllegalArgumentException("Tried to register modal handler '%s' at %s but it was already registered at %s".formatted(handlerInfo.getHandlerName(), Utils.formatMethodShort(handlerInfo.getMethod()), Utils.formatMethodShort(oldHandler.getMethod())));
        }
    }

    @Nullable
    public ModalHandlerInfo getModalHandler(String handlerName) {
        return this.modalHandlersMap.get(handlerName);
    }

    @Override
    public void addLocalizations(@NotNull String bundleName, @NotNull @NotNull List<@NotNull DiscordLocale> locales) {
        this.baseNameToLocalesMap.computeIfAbsent(bundleName, x -> new ArrayList()).addAll(ApplicationCommandsContextImpl.toLocales(locales));
    }

    @Override
    public void removeLocalizations(@NotNull String bundleName, @NotNull @NotNull List<@NotNull DiscordLocale> locales) {
        this.baseNameToLocalesMap.computeIfAbsent(bundleName, x -> new ArrayList()).removeAll(ApplicationCommandsContextImpl.toLocales(locales));
    }

    @Override
    public void removeLocalizations(@NotNull String bundleName) {
        this.baseNameToLocalesMap.remove(bundleName);
    }

    public Map<String, List<Locale>> getBaseNameToLocalesMap() {
        return this.baseNameToLocalesMap;
    }

    private static List<Locale> toLocales(List<DiscordLocale> locales) {
        return locales.stream().map(d -> Locale.forLanguageTag(d.getLocale())).toList();
    }
}

