/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal.application;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.application.CommandUpdateResult;
import com.freya02.botcommands.api.application.context.annotations.JDAMessageCommand;
import com.freya02.botcommands.api.application.context.annotations.JDAUserCommand;
import com.freya02.botcommands.api.application.context.message.GlobalMessageEvent;
import com.freya02.botcommands.api.application.context.message.GuildMessageEvent;
import com.freya02.botcommands.api.application.context.user.GlobalUserEvent;
import com.freya02.botcommands.api.application.context.user.GuildUserEvent;
import com.freya02.botcommands.api.application.slash.GlobalSlashEvent;
import com.freya02.botcommands.api.application.slash.GuildSlashEvent;
import com.freya02.botcommands.api.application.slash.annotations.JDASlashCommand;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.application.ApplicationCommandInfoMap;
import com.freya02.botcommands.internal.application.ApplicationCommandsCache;
import com.freya02.botcommands.internal.application.ApplicationCommandsUpdater;
import com.freya02.botcommands.internal.application.context.message.MessageCommandInfo;
import com.freya02.botcommands.internal.application.context.user.UserCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.utils.ReflectionUtils;
import com.freya02.botcommands.internal.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class ApplicationCommandsBuilder {
    private static final Logger LOGGER = Logging.getLogger();
    private final ExecutorService es = Executors.newFixedThreadPool(Math.min(4, Runtime.getRuntime().availableProcessors()));
    private final BContextImpl context;
    private final List<Long> slashGuildIds;
    private final ReentrantLock globalLock = new ReentrantLock();
    private final Map<Long, ReentrantLock> lockMap = Collections.synchronizedMap(new HashMap());

    public ApplicationCommandsBuilder(@NotNull BContextImpl context, List<Long> slashGuildIds) {
        this.context = context;
        this.slashGuildIds = slashGuildIds;
        this.context.setSlashCommandsBuilder(this);
    }

    public void processApplicationCommand(ApplicationCommand applicationCommand, Method method) {
        try {
            if (method.isAnnotationPresent(JDASlashCommand.class)) {
                this.processSlashCommand(applicationCommand, method);
            } else if (method.isAnnotationPresent(JDAUserCommand.class)) {
                this.processUserCommand(applicationCommand, method);
            } else if (method.isAnnotationPresent(JDAMessageCommand.class)) {
                this.processMessageCommand(applicationCommand, method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while processing application command at " + Utils.formatMethodShort(method), e);
        }
    }

    private void processUserCommand(ApplicationCommand applicationCommand, Method method) {
        if (method.getAnnotation(JDAUserCommand.class).scope().isGuildOnly()) {
            if (!ReflectionUtils.hasFirstParameter(method, GlobalUserEvent.class) && !ReflectionUtils.hasFirstParameter(method, GuildUserEvent.class)) {
                throw new IllegalArgumentException("User command at " + Utils.formatMethodShort(method) + " must have a GuildUserEvent or GlobalUserEvent as first parameter");
            }
            if (!ReflectionUtils.hasFirstParameter(method, GuildUserEvent.class)) {
                LOGGER.warn("Guild-only user command {} uses GlobalUserEvent, consider using GuildUserEvent to remove warnings related to guild stuff's nullability", (Object)Utils.formatMethodShort(method));
            }
        } else if (!ReflectionUtils.hasFirstParameter(method, GlobalUserEvent.class)) {
            throw new IllegalArgumentException("User command at " + Utils.formatMethodShort(method) + " must have a GlobalUserEvent as first parameter");
        }
        UserCommandInfo info = new UserCommandInfo(this.context, applicationCommand, method);
        CommandPath effectivePath = this.context.addUserCommand(info);
        LOGGER.debug("Added user command {} for method {}", (Object)effectivePath, (Object)Utils.formatMethodShort(method));
    }

    private void processMessageCommand(ApplicationCommand applicationCommand, Method method) {
        if (method.getAnnotation(JDAMessageCommand.class).scope().isGuildOnly()) {
            if (!ReflectionUtils.hasFirstParameter(method, GlobalMessageEvent.class) && !ReflectionUtils.hasFirstParameter(method, GuildMessageEvent.class)) {
                throw new IllegalArgumentException("Message command at " + Utils.formatMethodShort(method) + " must have a GuildMessageEvent or GlobalMessageEvent as first parameter");
            }
            if (!ReflectionUtils.hasFirstParameter(method, GuildMessageEvent.class)) {
                LOGGER.warn("Guild-only message command {} uses GlobalMessageEvent, consider using GuildMessageEvent to remove warnings related to guild stuff's nullability", (Object)Utils.formatMethodShort(method));
            }
        } else if (!ReflectionUtils.hasFirstParameter(method, GlobalMessageEvent.class)) {
            throw new IllegalArgumentException("Message command at " + Utils.formatMethodShort(method) + " must have a GlobalMessageEvent as first parameter");
        }
        MessageCommandInfo info = new MessageCommandInfo(this.context, applicationCommand, method);
        CommandPath effectivePath = this.context.addMessageCommand(info);
        LOGGER.debug("Added message command {} for method {}", (Object)effectivePath, (Object)Utils.formatMethodShort(method));
    }

    private void processSlashCommand(ApplicationCommand applicationCommand, Method method) {
        if (method.getAnnotation(JDASlashCommand.class).scope().isGuildOnly()) {
            if (!ReflectionUtils.hasFirstParameter(method, GlobalSlashEvent.class) && !ReflectionUtils.hasFirstParameter(method, GuildSlashEvent.class)) {
                throw new IllegalArgumentException("Slash command at " + Utils.formatMethodShort(method) + " must have a GuildSlashEvent or GlobalSlashEvent as first parameter");
            }
            if (!ReflectionUtils.hasFirstParameter(method, GuildSlashEvent.class)) {
                LOGGER.warn("Guild-only slash command {} uses GlobalSlashEvent, consider using GuildSlashEvent to remove warnings related to guild stuff's nullability", (Object)Utils.formatMethodShort(method));
            }
        } else if (!ReflectionUtils.hasFirstParameter(method, GlobalSlashEvent.class)) {
            throw new IllegalArgumentException("Slash command at " + Utils.formatMethodShort(method) + " must have a GlobalSlashEvent as first parameter");
        }
        SlashCommandInfo info = new SlashCommandInfo(this.context, applicationCommand, method);
        CommandPath effectivePath = this.context.addSlashCommand(info);
        LOGGER.debug("Added slash command path {} for method {}", (Object)effectivePath, (Object)Utils.formatMethodShort(method));
    }

    private String getCheckTypeString() {
        if (this.context.isOnlineAppCommandCheckEnabled()) {
            return "Online check";
        }
        return "Local disk check";
    }

    public void postProcess() throws IOException {
        this.context.getJDA().setRequiredScopes(new String[]{"applications.commands"});
        this.context.setApplicationCommandsCache(new ApplicationCommandsCache(this.context));
        this.es.submit(() -> {
            try {
                this.globalLock.lock();
                ApplicationCommandsUpdater globalUpdater = ApplicationCommandsUpdater.ofGlobal(this.context, this.context.isOnlineAppCommandCheckEnabled());
                if (globalUpdater.shouldUpdateCommands()) {
                    globalUpdater.updateCommands();
                    LOGGER.debug("Global commands were updated ({})", (Object)this.getCheckTypeString());
                } else {
                    LOGGER.debug("Global commands does not have to be updated ({})", (Object)this.getCheckTypeString());
                }
                this.context.getApplicationCommandsContext().putLiveApplicationCommandsMap(null, ApplicationCommandInfoMap.fromCommandList(globalUpdater.getScopeApplicationCommands()));
            }
            catch (Throwable e) {
                LOGGER.error("An error occurred while updating global commands", e);
            }
            finally {
                this.globalLock.unlock();
            }
        });
        ShardManager shardManager = this.context.getJDA().getShardManager();
        Map<Guild, CompletableFuture<CommandUpdateResult>> map = shardManager != null ? this.scheduleApplicationCommandsUpdate((Iterable<Guild>)shardManager.getGuildCache(), false, this.context.isOnlineAppCommandCheckEnabled()) : this.scheduleApplicationCommandsUpdate((Iterable<Guild>)this.context.getJDA().getGuildCache(), false, this.context.isOnlineAppCommandCheckEnabled());
        map.forEach((guild, future) -> future.whenComplete((result, throwable) -> this.handleApplicationUpdateException((Guild)guild, (Throwable)throwable)));
    }

    void handleApplicationUpdateException(Guild guild, Throwable throwable) {
        if (throwable != null) {
            ErrorResponseException e = Utils.getErrorResponseException(throwable);
            if (e != null && e.getErrorResponse() == ErrorResponse.MISSING_ACCESS) {
                String inviteUrl = this.context.getJDA().getInviteUrl(new Permission[0]) + "&guild_id=" + guild.getId();
                LOGGER.warn("Could not register guild commands for guild '{}' ({}) as it appears the OAuth2 grants misses applications.commands, you can re-invite the bot in this guild with its already existing permission with this link: {}", new Object[]{guild.getName(), guild.getId(), inviteUrl});
                this.context.getRegistrationListeners().forEach(r -> r.onGuildSlashCommandMissingAccess(guild, inviteUrl));
            } else {
                LOGGER.error("Encountered an exception while updating commands for guild '{}' ({})", new Object[]{guild.getName(), guild.getId(), throwable});
            }
        }
    }

    @NotNull
    public Map<Guild, CompletableFuture<CommandUpdateResult>> scheduleApplicationCommandsUpdate(@NotNull Iterable<Guild> guilds, boolean force, boolean onlineCheck) {
        HashMap<Guild, CompletableFuture<CommandUpdateResult>> map = new HashMap<Guild, CompletableFuture<CommandUpdateResult>>();
        for (Guild guild : guilds) {
            if (!this.slashGuildIds.isEmpty() && !this.slashGuildIds.contains(guild.getIdLong())) continue;
            map.put(guild, this.scheduleApplicationCommandsUpdate(guild, force, onlineCheck));
        }
        return map;
    }

    @NotNull
    public CompletableFuture<CommandUpdateResult> scheduleApplicationCommandsUpdate(Guild guild, boolean force, boolean onlineCheck) {
        if (!this.slashGuildIds.isEmpty() && !this.slashGuildIds.contains(guild.getIdLong())) {
            return CompletableFuture.completedFuture(new CommandUpdateResult(guild, false));
        }
        return CompletableFuture.supplyAsync(() -> {
            ReentrantLock lock;
            Map<Long, ReentrantLock> map = this.lockMap;
            synchronized (map) {
                lock = this.lockMap.computeIfAbsent(guild.getIdLong(), x -> new ReentrantLock());
            }
            try {
                lock.lock();
                ApplicationCommandsUpdater updater = ApplicationCommandsUpdater.ofGuild(this.context, guild, onlineCheck);
                boolean updatedCommands = false;
                if (force || updater.shouldUpdateCommands()) {
                    updater.updateCommands();
                    updatedCommands = true;
                    LOGGER.debug("Guild '{}' ({}) commands were{} updated ({})", new Object[]{guild.getName(), guild.getId(), force ? " force" : "", this.getCheckTypeString()});
                } else {
                    LOGGER.debug("Guild '{}' ({}) commands does not have to be updated ({})", new Object[]{guild.getName(), guild.getId(), this.getCheckTypeString()});
                }
                this.context.getApplicationCommandsContext().putLiveApplicationCommandsMap(guild, ApplicationCommandInfoMap.fromCommandList(updater.getScopeApplicationCommands()));
                CommandUpdateResult commandUpdateResult = new CommandUpdateResult(guild, updatedCommands);
                return commandUpdateResult;
            }
            catch (Throwable e) {
                throw new RuntimeException("An exception occurred while updating guild commands for guild '" + guild.getName() + "' (" + guild.getId() + ")", e);
            }
            finally {
                lock.unlock();
            }
        }, this.es);
    }
}

