/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.BCInfo;
import com.freya02.botcommands.api.Logging;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.dv8tion.jda.api.JDAInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u0011\u0012B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/freya02/botcommands/internal/Version;", "", "minor", "", "major", "revision", "classifier", "Lcom/freya02/botcommands/internal/Version$Classifier;", "(IIILcom/freya02/botcommands/internal/Version$Classifier;)V", "getClassifier", "()Lcom/freya02/botcommands/internal/Version$Classifier;", "getMajor", "()I", "getMinor", "getRevision", "compareTo", "other", "Classifier", "Companion", "BotCommands"})
public final class Version
implements Comparable<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int minor;
    private final int major;
    private final int revision;
    @Nullable
    private final Classifier classifier;
    private static final Logger logger = Logging.getLogger(Version.class);
    @NotNull
    private static final Regex versionPattern = new Regex("(\\d+)\\.(\\d+)\\.(\\d+)(?:-(\\w+)\\.(\\d+))?(?:_\\w*)?");
    @NotNull
    private static final List<String> classifiers;

    private Version(int minor, int major, int revision, Classifier classifier) {
        this.minor = minor;
        this.major = major;
        this.revision = revision;
        this.classifier = classifier;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getRevision() {
        return this.revision;
    }

    @Nullable
    public final Classifier getClassifier() {
        return this.classifier;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.major != other.major) {
            return Intrinsics.compare((int)this.major, (int)other.major);
        }
        if (this.minor != other.minor) {
            return Intrinsics.compare((int)this.minor, (int)other.minor);
        }
        if (this.revision != other.revision) {
            return Intrinsics.compare((int)this.revision, (int)other.revision);
        }
        if (!Intrinsics.areEqual((Object)this.classifier, (Object)other.classifier)) {
            return this.classifier == null ? 1 : (other.classifier == null ? -1 : this.classifier.compareTo(other.classifier));
        }
        return 0;
    }

    @JvmStatic
    public static final void checkVersions() {
        Companion.checkVersions();
    }

    public /* synthetic */ Version(int minor, int major, int revision, Classifier classifier, DefaultConstructorMarker $constructor_marker) {
        this(minor, major, revision, classifier);
    }

    static {
        Object[] objectArray = new String[]{"alpha", "beta"};
        classifiers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\u0011\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/freya02/botcommands/internal/Version$Classifier;", "", "name", "", "version", "", "(Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "getVersion", "()I", "classifierIndex", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "BotCommands"})
    public static final class Classifier
    implements Comparable<Classifier> {
        @NotNull
        private final String name;
        private final int version;

        public Classifier(@NotNull String name, int version) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.version = version;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getVersion() {
            return this.version;
        }

        @Override
        public int compareTo(@NotNull Classifier other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!Intrinsics.areEqual((Object)this.name, (Object)other.name)) {
                return Intrinsics.compare((int)this.classifierIndex(), (int)other.classifierIndex());
            }
            return Intrinsics.compare((int)this.version, (int)other.version);
        }

        private final int classifierIndex() {
            return classifiers.indexOf(this.name);
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.version;
        }

        @NotNull
        public final Classifier copy(@NotNull String name, int version) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Classifier(name, version);
        }

        public static /* synthetic */ Classifier copy$default(Classifier classifier, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = classifier.name;
            }
            if ((n2 & 2) != 0) {
                n = classifier.version;
            }
            return classifier.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Classifier(name=" + this.name + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.version);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Classifier)) {
                return false;
            }
            Classifier classifier = (Classifier)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)classifier.name)) {
                return false;
            }
            return this.version == classifier.version;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/freya02/botcommands/internal/Version$Companion;", "", "()V", "classifiers", "", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "versionPattern", "Lkotlin/text/Regex;", "checkVersions", "", "get", "Lcom/freya02/botcommands/internal/Version;", "versionString", "getOrNull", "BotCommands"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void checkVersions() {
            logger.debug("Loading BotCommands " + BCInfo.VERSION + " ; Compiled with JDA 5.0.0-beta.8 ; Running with JDA " + JDAInfo.VERSION);
            String requiredJdaVersionStr = "5.0.0-beta.8";
            Version version = this.getOrNull(requiredJdaVersionStr);
            if (version == null) {
                Companion it = this;
                boolean bl = false;
                logger.warn("Unrecognized built-with JDA version: " + requiredJdaVersionStr);
                return;
            }
            Version requiredJdaVersion = version;
            String currentJdaVersionStr = JDAInfo.VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)currentJdaVersionStr, (String)"currentJdaVersionStr");
            Version version2 = this.getOrNull(currentJdaVersionStr);
            if (version2 == null) {
                Companion it = this;
                boolean bl = false;
                logger.warn("Unrecognized JDA version: " + currentJdaVersionStr);
                return;
            }
            Version currentJdaVersion = version2;
            if (currentJdaVersion.compareTo(requiredJdaVersion) < 0) {
                throw new IllegalStateException("This bot is currently running JDA " + currentJdaVersionStr + " but requires at least " + requiredJdaVersionStr);
            }
        }

        @NotNull
        public final Version get(@NotNull String versionString) {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            Version version = this.getOrNull(versionString);
            if (version == null) {
                throw new IllegalArgumentException("Cannot parse version '" + versionString + "'");
            }
            return version;
        }

        @Nullable
        public final Version getOrNull(@NotNull String versionString) {
            Classifier classifier;
            String classifierName;
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            MatchResult matchResult = versionPattern.matchEntire((CharSequence)versionString);
            if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
                return null;
            }
            MatchResult groups = matchResult;
            Object object = groups.get(1);
            if (object == null || (object = object.getValue()) == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
                return null;
            }
            int major = (Integer)object;
            Object object2 = groups.get(2);
            if (object2 == null || (object2 = object2.getValue()) == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
                return null;
            }
            int minor = (Integer)object2;
            Object object3 = groups.get(3);
            if (object3 == null || (object3 = object3.getValue()) == null || (object3 = StringsKt.toIntOrNull((String)object3)) == null) {
                return null;
            }
            int revision = (Integer)object3;
            MatchGroup matchGroup = groups.get(4);
            String string = classifierName = matchGroup != null ? matchGroup.getValue() : null;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!classifiers.contains(it)) {
                    return null;
                }
                Object object4 = groups.get(5);
                if (object4 == null || (object4 = object4.getValue()) == null || (object4 = StringsKt.toIntOrNull((String)object4)) == null) {
                    return null;
                }
                int classifierVersion = (Integer)object4;
                classifier = new Classifier(it, classifierVersion);
            } else {
                classifier = null;
            }
            Classifier classifier2 = classifier;
            return new Version(minor, major, revision, classifier2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

