/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.SettingsProvider;
import com.freya02.botcommands.internal.NSFWState;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.prefixed.TextCommandInfo;
import java.util.EnumSet;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import net.dv8tion.jda.api.entities.channel.middleman.StandardGuildMessageChannel;
import net.dv8tion.jda.api.interactions.Interaction;

public class Usability {
    private final EnumSet<UnusableReason> unusableReasons;

    private Usability(EnumSet<UnusableReason> unusableReasons) {
        this.unusableReasons = unusableReasons;
    }

    private static void checkNSFW(BContext context, EnumSet<UnusableReason> unusableReasons, GuildMessageChannel msgChannel, TextCommandInfo cmdInfo) {
        NSFWState nsfwState = cmdInfo.getNSFWState();
        if (nsfwState == null) {
            return;
        }
        if (msgChannel instanceof ThreadChannel) {
            ThreadChannel threadChannel = (ThreadChannel)msgChannel;
            msgChannel = threadChannel.getParentMessageChannel();
        }
        if (msgChannel instanceof StandardGuildMessageChannel) {
            StandardGuildMessageChannel channel = (StandardGuildMessageChannel)msgChannel;
            if (!nsfwState.isEnabledInGuild()) {
                unusableReasons.add(UnusableReason.NSFW_DISABLED);
            } else if (!channel.isNSFW()) {
                unusableReasons.add(UnusableReason.NSFW_ONLY);
            }
        } else if (msgChannel instanceof PrivateChannel) {
            PrivateChannel channel = (PrivateChannel)msgChannel;
            if (!nsfwState.isEnabledInDMs()) {
                unusableReasons.add(UnusableReason.NSFW_DISABLED);
            } else {
                SettingsProvider provider = context.getSettingsProvider();
                if (provider == null) {
                    unusableReasons.add(UnusableReason.NSFW_DM_DENIED);
                } else if (!provider.doesUserConsentNSFW(channel.getUser())) {
                    unusableReasons.add(UnusableReason.NSFW_DM_DENIED);
                }
            }
        }
    }

    public static Usability of(BContext context, TextCommandInfo cmdInfo, Member member, GuildMessageChannel channel, boolean isNotOwner) {
        EnumSet<UnusableReason> unusableReasons = EnumSet.noneOf(UnusableReason.class);
        if (isNotOwner && cmdInfo.isHidden()) {
            unusableReasons.add(UnusableReason.HIDDEN);
        }
        if (isNotOwner && cmdInfo.isOwnerRequired()) {
            unusableReasons.add(UnusableReason.OWNER_ONLY);
        }
        Usability.checkNSFW(context, unusableReasons, channel, cmdInfo);
        if (isNotOwner && !member.hasPermission((GuildChannel)channel, cmdInfo.getUserPermissions())) {
            unusableReasons.add(UnusableReason.USER_PERMISSIONS);
        }
        if (!channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, cmdInfo.getBotPermissions())) {
            unusableReasons.add(UnusableReason.BOT_PERMISSIONS);
        }
        return new Usability(unusableReasons);
    }

    public static Usability of(Interaction event, ApplicationCommandInfo cmdInfo, boolean isNotOwner) {
        EnumSet<UnusableReason> unusableReasons = EnumSet.noneOf(UnusableReason.class);
        if (!event.isFromGuild() && cmdInfo.isGuildOnly()) {
            unusableReasons.add(UnusableReason.GUILD_ONLY);
        }
        if (!event.isFromGuild()) {
            return new Usability(unusableReasons);
        }
        GuildChannel channel = event.getGuildChannel();
        Guild guild = Objects.requireNonNull(event.getGuild(), "Guild shouldn't be null as this code path is guild-only");
        Member member = Objects.requireNonNull(event.getMember(), "Member shouldn't be null as this code path is guild-only");
        if (!guild.getSelfMember().hasPermission(channel, cmdInfo.getBotPermissions())) {
            unusableReasons.add(UnusableReason.BOT_PERMISSIONS);
        }
        if (isNotOwner && cmdInfo.isOwnerRequired()) {
            unusableReasons.add(UnusableReason.OWNER_ONLY);
        }
        if (isNotOwner && !member.hasPermission(channel, cmdInfo.getUserPermissions())) {
            unusableReasons.add(UnusableReason.USER_PERMISSIONS);
        }
        return new Usability(unusableReasons);
    }

    public boolean isUnusable() {
        for (UnusableReason reason : this.unusableReasons) {
            if (reason.isUsable()) continue;
            return true;
        }
        return false;
    }

    public boolean isUsable() {
        return !this.isUnusable();
    }

    public boolean isNotShowable() {
        for (UnusableReason reason : this.unusableReasons) {
            if (reason.isShowable()) continue;
            return true;
        }
        return false;
    }

    public boolean isShowable() {
        return !this.isNotShowable();
    }

    public EnumSet<UnusableReason> getUnusableReasons() {
        return this.unusableReasons;
    }

    public static enum UnusableReason {
        HIDDEN(false, false),
        OWNER_ONLY(false, false),
        USER_PERMISSIONS(false, false),
        BOT_PERMISSIONS(true, false),
        GUILD_ONLY(false, false),
        NSFW_DISABLED(false, false),
        NSFW_ONLY(false, false),
        NSFW_DM_DENIED(false, false);

        private final boolean showable;
        private final boolean usable;

        private UnusableReason(boolean showable, boolean usable) {
            this.showable = showable;
            this.usable = usable;
        }

        public boolean isShowable() {
            return this.showable;
        }

        public boolean isUsable() {
            return this.usable;
        }
    }
}

