/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.internal.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class ConflictDetector {
    private static final Pattern PACKAGE_SPLIT_PATTERN = Pattern.compile("[/.]");
    private static final Logger LOGGER = Logging.getLogger();

    private static Path getFsPath(FileSystem fs, String packageStr) {
        String[] split = PACKAGE_SPLIT_PATTERN.split(packageStr);
        Path path = fs.getPath("", new String[0]);
        for (String s : split) {
            path = path.resolve(s);
        }
        return path;
    }

    public static void detectConflicts() throws IOException {
        String classPath = System.getProperty("java.class.path");
        for (String jarPathStr : classPath.split(";")) {
            ClassPathItem classPathItem;
            Path jarPath = Path.of(jarPathStr, new String[0]);
            if (Files.isRegularFile(jarPath, new LinkOption[0]) && IOUtils.getFileExtension(jarPath).equals("jar")) {
                FileSystem fs = FileSystems.newFileSystem(jarPath, (ClassLoader)null);
                classPathItem = new ClassPathItem(fs, jarPath, fs.getPath("", new String[0]), false);
            } else {
                if (!Files.isDirectory(jarPath, new LinkOption[0])) continue;
                classPathItem = new ClassPathItem(jarPath.getFileSystem(), jarPath, jarPath, true);
            }
            try (ClassPathItem item = classPathItem;){
                Path source = item.source;
                Path root = item.root;
                FileSystem fs = item.fs;
                Map<String, Path> libMap = Map.of("JDA-Utils", ConflictDetector.getFsPath(fs, "com/jagrosh/jdautilities/command"), "JDA-Chewtils", ConflictDetector.getFsPath(fs, "pw/chew/jdachewtils/command"), "Flight", ConflictDetector.getFsPath(fs, "me/devoxin/flight"), "jda-commands", ConflictDetector.getFsPath(fs, "com/github/kaktushose/jda/commands"), "rimor", ConflictDetector.getFsPath(fs, "com/jasperls/rimor"));
                for (Map.Entry<String, Path> entry : libMap.entrySet()) {
                    String libName = entry.getKey();
                    Path packagePath = entry.getValue();
                    Path resolved = root.resolve(packagePath);
                    if (!Files.exists(resolved, new LinkOption[0])) continue;
                    LOGGER.warn("Detected an incompatible command library ({}) in your classpath at path: '{}', this may interfere with this library, especially with application commands", (Object)libName, (Object)source);
                }
            }
        }
    }

    private record ClassPathItem(FileSystem fs, Path source, Path root, boolean isDirectory) implements Closeable
    {
        @Override
        public void close() throws IOException {
            if (!this.isDirectory) {
                this.fs.close();
            }
        }
    }
}

