/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.internal;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.annotations.CommandId;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.internal.Cooldownable;
import com.freya02.botcommands.internal.ExecutableInteractionInfo;
import com.freya02.botcommands.internal.runner.MethodRunner;
import com.freya02.botcommands.internal.utils.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.function.Function;
import net.dv8tion.jda.api.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommandInfo<T>
extends Cooldownable
implements ExecutableInteractionInfo {
    private final T instance;
    protected final CommandPath path;
    protected final boolean ownerRequired;
    protected final Method commandMethod;
    protected final EnumSet<Permission> userPermissions;
    protected final EnumSet<Permission> botPermissions;
    private final String commandId;
    private final MethodRunner methodRunner;

    @SafeVarargs
    protected <A extends Annotation> AbstractCommandInfo(@NotNull BContext context, @NotNull T instance, @NotNull A annotation, @NotNull Method commandMethod, Function<A, String> ... nameComponentsFunctions) {
        super(AnnotationUtils.getEffectiveCooldownStrategy(commandMethod));
        this.instance = instance;
        String[] pathComponents = new String[nameComponentsFunctions.length];
        for (int i = 0; i < nameComponentsFunctions.length; ++i) {
            String component = nameComponentsFunctions[i].apply(annotation);
            pathComponents[i] = component.isEmpty() ? null : component;
        }
        this.path = CommandPath.of(pathComponents);
        this.commandMethod = commandMethod;
        this.methodRunner = context.getMethodRunnerFactory().make(instance, commandMethod);
        this.ownerRequired = AnnotationUtils.getEffectiveRequireOwnerState(commandMethod);
        CommandId commandIdAnnot = commandMethod.getAnnotation(CommandId.class);
        this.commandId = commandIdAnnot != null ? commandIdAnnot.value() : null;
        this.userPermissions = AnnotationUtils.getEffectiveUserPermissions(commandMethod);
        this.botPermissions = AnnotationUtils.getEffectiveBotPermissions(commandMethod);
    }

    @NotNull
    public T getInstance() {
        return this.instance;
    }

    @Override
    @NotNull
    public Method getMethod() {
        return this.commandMethod;
    }

    @Override
    @NotNull
    public MethodRunner getMethodRunner() {
        return this.methodRunner;
    }

    public CommandPath getPath() {
        return this.path;
    }

    public EnumSet<Permission> getUserPermissions() {
        return this.userPermissions;
    }

    public EnumSet<Permission> getBotPermissions() {
        return this.botPermissions;
    }

    public boolean isOwnerRequired() {
        return this.ownerRequired;
    }

    @Nullable
    public String getCommandId() {
        return this.commandId;
    }
}

