/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.pagination.menu;

import com.freya02.botcommands.api.components.Components;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.components.builder.buttons.LambdaButtonBuilder;
import com.freya02.botcommands.api.pagination.ButtonContentSupplier;
import com.freya02.botcommands.api.pagination.PaginatorSupplier;
import com.freya02.botcommands.api.pagination.TimeoutInfo;
import com.freya02.botcommands.api.pagination.menu.BasicMenu;
import com.freya02.botcommands.api.pagination.menu.ChoiceCallback;
import com.freya02.botcommands.api.pagination.menu.MenuPage;
import com.freya02.botcommands.api.pagination.menu.RowPrefixSupplier;
import com.freya02.botcommands.api.pagination.transformer.EntryTransformer;
import com.freya02.botcommands.api.utils.ButtonContent;
import java.util.List;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.internal.utils.Checks;

public final class ChoiceMenu<E>
extends BasicMenu<E, ChoiceMenu<E>> {
    private final ButtonContentSupplier<E> buttonContentSupplier;
    private final ChoiceCallback<E> callback;

    ChoiceMenu(InteractionConstraints constraints, TimeoutInfo<ChoiceMenu<E>> timeout, boolean hasDeleteButton, ButtonContent firstContent, ButtonContent previousContent, ButtonContent nextContent, ButtonContent lastContent, ButtonContent deleteContent, List<E> entries, int maxEntriesPerPage, EntryTransformer<? super E> transformer, RowPrefixSupplier rowPrefixSupplier, PaginatorSupplier<ChoiceMenu<E>> supplier, ButtonContentSupplier<E> buttonContentSupplier, ChoiceCallback<E> callback) {
        super(constraints, timeout, hasDeleteButton, firstContent, previousContent, nextContent, lastContent, deleteContent, ChoiceMenu.makePages(entries, transformer, rowPrefixSupplier, maxEntriesPerPage), supplier);
        Checks.notNull(buttonContentSupplier, (String)"Button content supplier");
        Checks.notNull(callback, (String)"Callback");
        this.buttonContentSupplier = buttonContentSupplier;
        this.callback = callback;
    }

    @Override
    protected void putComponents() {
        super.putComponents();
        MenuPage page = (MenuPage)this.pages.get(this.page);
        List entries = page.entries();
        for (int i = 0; i < entries.size(); ++i) {
            Object item = entries.get(i);
            ButtonContent content = this.buttonContentSupplier.apply(item, i);
            Button choiceButton = ((LambdaButtonBuilder)Components.primaryButton(event -> {
                this.cleanup(event.getContext());
                this.callback.accept(event, item);
            }).setConstraints(this.constraints)).build(content);
            this.components.addComponents(1 + i / 5, new ActionComponent[]{choiceButton});
        }
    }
}

