/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.pagination.interactive;

import com.freya02.botcommands.api.components.Components;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.components.builder.selects.LambdaStringSelectionMenuBuilder;
import com.freya02.botcommands.api.components.event.StringSelectionEvent;
import com.freya02.botcommands.api.pagination.PaginatorComponents;
import com.freya02.botcommands.api.pagination.TimeoutInfo;
import com.freya02.botcommands.api.pagination.interactive.InteractiveMenuItem;
import com.freya02.botcommands.api.pagination.interactive.SelectContent;
import com.freya02.botcommands.api.pagination.paginator.BasicPaginator;
import com.freya02.botcommands.api.utils.ButtonContent;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.selections.SelectOption;
import net.dv8tion.jda.api.interactions.components.selections.StringSelectMenu;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.internal.utils.Checks;
import org.jetbrains.annotations.NotNull;

public abstract class BasicInteractiveMenu<T extends BasicInteractiveMenu<T>>
extends BasicPaginator<T> {
    protected final List<InteractiveMenuItem<T>> items;
    protected int selectedItem = 0;
    protected final boolean usePaginator;

    protected BasicInteractiveMenu(InteractionConstraints constraints, TimeoutInfo<T> timeout, boolean hasDeleteButton, ButtonContent firstContent, ButtonContent previousContent, ButtonContent nextContent, ButtonContent lastContent, ButtonContent deleteContent, @NotNull List<InteractiveMenuItem<T>> items, boolean usePaginator) {
        super(constraints, timeout, 0, (T a, MessageEditBuilder b, PaginatorComponents c, int d) -> new EmbedBuilder().build(), hasDeleteButton, firstContent, previousContent, nextContent, lastContent, deleteContent);
        if (items.isEmpty()) {
            throw new IllegalStateException("No interactive menu items has been added");
        }
        this.usePaginator = usePaginator;
        this.items = items;
        this.setSelectedItem(0);
    }

    @NotNull
    protected StringSelectMenu.Builder createSelectMenuBuilder() {
        LambdaStringSelectionMenuBuilder builder = (LambdaStringSelectionMenuBuilder)Components.stringSelectionMenu(this::handleSelection).oneUse().setConstraints(this.constraints);
        List options = builder.getOptions();
        int itemsSize = this.items.size();
        for (int i = 0; i < itemsSize; ++i) {
            InteractiveMenuItem<T> item = this.items.get(i);
            SelectOption option = item.content().toSelectOption(String.valueOf(i));
            if (i == this.selectedItem) {
                option = option.withDefault(true);
            }
            options.add(option);
        }
        return builder;
    }

    private void handleSelection(StringSelectionEvent event) {
        this.selectedItem = Integer.parseInt((String)event.getValues().get(0));
        event.editMessage(this.get()).queue();
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public SelectContent getSelectedItemContent() {
        return this.items.get(this.selectedItem).content();
    }

    public T setSelectedItem(int itemIndex) {
        Checks.check((itemIndex >= 0 ? 1 : 0) != 0, (String)"Item index cannot be negative");
        Checks.check((itemIndex < this.items.size() ? 1 : 0) != 0, (String)"Item index cannot be higher than max items count (%d)", (Object)this.items.size());
        this.selectedItem = itemIndex;
        this.setMaxPages(this.items.get(itemIndex).maxPages());
        this.setPage(0);
        return (T)this;
    }

    public T setSelectedItem(String itemLabel) {
        Checks.notEmpty((CharSequence)itemLabel, (String)"Item name cannot be empty");
        for (int i = 0; i < this.items.size(); ++i) {
            String label = this.items.get(i).content().label();
            if (!label.equals(itemLabel)) continue;
            return this.setSelectedItem(i);
        }
        throw new IllegalArgumentException("Item name '" + itemLabel + "' cannot be found in this interactive menu");
    }

    @Override
    public MessageEditData get() {
        this.onPreGet();
        if (this.usePaginator) {
            this.putComponents();
        }
        this.components.addComponents(new ActionComponent[]{this.createSelectMenuBuilder().build()});
        MessageEmbed embed = this.items.get(this.selectedItem).supplier().get(this, this.getPage(), this.messageBuilder, this.components);
        this.messageBuilder.setEmbeds(new MessageEmbed[]{embed});
        this.messageBuilder.setComponents(this.components.getActionRows());
        this.onPostGet();
        return this.messageBuilder.build();
    }
}

