/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.pagination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.internal.utils.Checks;

public class PaginatorComponents {
    private final List<List<ActionComponent>> actionRows = new ArrayList<List<ActionComponent>>(5);

    public void addComponents(int row, ActionComponent ... components) {
        if (row >= 5) {
            throw new IllegalArgumentException("Cannot have more than 5 rows");
        }
        if (this.actionRows.size() <= row) {
            this.actionRows.add(new ArrayList<ActionComponent>(Arrays.asList(components)));
        } else {
            List<ActionComponent> list = this.actionRows.get(row);
            if (list.size() + components.length > 5) {
                throw new UnsupportedOperationException("Cannot put more than 5 buttons in row " + row + " (contains " + list.size() + ")");
            }
            Collections.addAll(list, components);
        }
    }

    public void addComponents(ActionComponent ... components) {
        Checks.check((this.actionRows.size() < 5 ? 1 : 0) != 0, (String)"There are already 5 action rows");
        Checks.check((components.length <= 5 ? 1 : 0) != 0, (String)"You cannot add more than 5 components in the same row");
        this.actionRows.add(Arrays.asList(components));
    }

    public List<ActionRow> getActionRows() {
        return this.actionRows.stream().map(ActionRow::of).toList();
    }

    public void clear() {
        this.actionRows.clear();
    }
}

