/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.pagination;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.components.ComponentManager;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.pagination.PaginatorComponents;
import com.freya02.botcommands.api.pagination.TimeoutInfo;
import com.freya02.botcommands.internal.utils.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class BasicPagination<T extends BasicPagination<T>> {
    private static final Logger LOGGER = Logging.getLogger();
    private static final ScheduledExecutorService TIMEOUT_SERVICE = Executors.newSingleThreadScheduledExecutor();
    protected final InteractionConstraints constraints;
    @Nullable
    protected final TimeoutInfo<T> timeout;
    protected final MessageEditBuilder messageBuilder = new MessageEditBuilder();
    protected final PaginatorComponents components = new PaginatorComponents();
    private final Set<String> usedIds = new HashSet<String>();
    @Nullable
    private ScheduledFuture<?> timeoutFuture;
    @Nullable
    private Message message;
    private boolean timeoutPassed = false;

    protected BasicPagination(@NotNull InteractionConstraints constraints, @Nullable TimeoutInfo<T> timeout) {
        this.constraints = constraints;
        this.timeout = timeout;
    }

    public abstract MessageEditData get();

    public void setMessage(@NotNull Message message) {
        this.message = message;
    }

    protected void onPreGet() {
        if (this.timeoutPassed && this.timeout != null) {
            LOGGER.warn("Timeout has already been cleaned up by pagination is still used ! Make sure you called BasicPagination#cleanup in the timeout consumer, timeout consumer at: {}", this.timeout.onTimeout().getClass().getNestHost());
        }
        this.messageBuilder.clear();
        this.components.clear();
        this.restartTimeout();
    }

    public void restartTimeout() {
        if (this.timeout != null) {
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
            this.timeoutFuture = TIMEOUT_SERVICE.schedule(() -> {
                this.timeoutPassed = true;
                this.timeout.onTimeout().accept(this, this.message);
            }, this.timeout.timeout(), this.timeout.unit());
        }
    }

    protected void onPostGet() {
        for (ActionRow row : this.components.getActionRows()) {
            for (ActionComponent component : row.getActionComponents()) {
                String id = component.getId();
                if (id == null) continue;
                this.usedIds.add(id);
            }
        }
    }

    public void cancelTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }

    public void cleanup(BContext context) {
        ComponentManager manager = Utils.getComponentManager(context);
        int deletedIds = manager.deleteIds(this.usedIds);
        LOGGER.trace("Cleaned up {} component IDs out of {}", (Object)deletedIds, (Object)this.usedIds.size());
        this.usedIds.clear();
    }
}

