/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.localization;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.localization.LocalizationMap;
import com.freya02.botcommands.api.localization.LocalizationTemplate;
import com.freya02.botcommands.api.localization.providers.LocalizationMapProviders;
import com.freya02.botcommands.internal.application.localization.BCLocalizationFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;

public class Localization {
    private static final Logger LOGGER = Logging.getLogger();
    private static final ResourceBundle.Control CONTROL = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private static final Map<String, Map<Locale, Localization>> localizationMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, ? extends LocalizationTemplate> templateMap;
    private final Locale effectiveLocale;

    private Localization(@NotNull LocalizationMap bundle) {
        this.effectiveLocale = bundle.effectiveLocale();
        this.templateMap = bundle.templateMap();
    }

    @Nullable
    private static BestLocale chooseBestLocale(String baseName, Locale targetLocale) {
        List<Locale> candidateLocales = CONTROL.getCandidateLocales(baseName, targetLocale);
        for (Locale candidateLocale : candidateLocales) {
            LocalizationMap localizationBundle = LocalizationMapProviders.cycleProviders(baseName, candidateLocale);
            if (localizationBundle == null) continue;
            return new BestLocale(localizationBundle.effectiveLocale(), localizationBundle);
        }
        return null;
    }

    @Nullable
    private static Localization retrieveBundle(String baseName, Locale targetLocale) {
        BestLocale bestLocale = Localization.chooseBestLocale(baseName, targetLocale);
        if (bestLocale == null) {
            if (Logging.tryLog(baseName)) {
                LOGGER.warn("Could not find localization resources for '{}'", (Object)baseName);
            }
            return null;
        }
        if (!bestLocale.locale().equals(targetLocale)) {
            if (bestLocale.locale().toString().isEmpty()) {
                if (Logging.tryLog(baseName, targetLocale.toLanguageTag())) {
                    LOGGER.warn("Unable to find bundle '{}' with locale '{}', falling back to neutral lang", (Object)baseName, (Object)targetLocale);
                }
            } else if (Logging.tryLog(baseName, targetLocale.toLanguageTag(), bestLocale.locale.toLanguageTag())) {
                LOGGER.warn("Unable to find bundle '{}' with locale '{}', falling back to '{}'", new Object[]{baseName, targetLocale, bestLocale.locale()});
            }
        }
        return new Localization(bestLocale.bundle());
    }

    public static void invalidateLocalization(@NotNull String baseName) {
        Logging.removeLogs(BCLocalizationFunction.class);
        Logging.removeLogs();
        localizationMap.remove(baseName);
    }

    public static void invalidateLocalization(@NotNull String baseName, @NotNull Locale locale) {
        Logging.removeLogs(BCLocalizationFunction.class);
        Logging.removeLogs();
        localizationMap.computeIfAbsent(baseName, x -> Collections.synchronizedMap(new HashMap())).remove(locale);
    }

    @Nullable
    public static Localization getInstance(@NotNull String baseName, @NotNull Locale locale) {
        Map localeMap = localizationMap.computeIfAbsent(baseName, x -> Collections.synchronizedMap(new HashMap()));
        Localization value = (Localization)localeMap.get(locale);
        if (value != null) {
            return value;
        }
        try {
            Localization newValue = Localization.retrieveBundle(baseName, locale);
            localeMap.put(locale, newValue);
            return newValue;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get bundle '%s' for locale '%s'".formatted(baseName, locale), e);
        }
    }

    @NotNull
    public @UnmodifiableView Map<String, ? extends LocalizationTemplate> getTemplateMap() {
        return Collections.unmodifiableMap(this.templateMap);
    }

    @Nullable
    public LocalizationTemplate get(String path) {
        return this.templateMap.get(path);
    }

    public Locale getEffectiveLocale() {
        return this.effectiveLocale;
    }

    private record BestLocale(Locale locale, LocalizationMap bundle) {
    }

    public record Entry(String key, Object value) {
        @NotNull
        public static Entry entry(@NotNull String key, @NotNull Object value) {
            return new Entry(key, value);
        }
    }
}

