/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.components.builder.buttons;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.components.ComponentManager;
import com.freya02.botcommands.api.components.builder.AbstractPersistentComponentBuilder;
import com.freya02.botcommands.api.utils.ButtonContent;
import com.freya02.botcommands.internal.utils.Utils;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.dv8tion.jda.internal.interactions.component.ButtonImpl;

public class PersistentButtonBuilder
extends AbstractPersistentComponentBuilder<PersistentButtonBuilder> {
    private final BContext context;
    private final String handlerName;
    private final String[] args;
    private final ButtonStyle buttonStyle;

    public PersistentButtonBuilder(BContext context, String handlerName, String[] args, ButtonStyle buttonStyle) {
        this.context = context;
        this.handlerName = handlerName;
        this.args = args;
        this.buttonStyle = buttonStyle;
    }

    @Override
    public String getHandlerName() {
        return this.handlerName;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public Button build(String label) {
        return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, null).withLabel(label);
    }

    public Button build(Emoji emoji) {
        return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, emoji);
    }

    public Button build(ButtonContent content) {
        if (content.text() != null) {
            if (content.emoji() != null) {
                return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, content.emoji()).withLabel(content.text());
            }
            return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, null).withLabel(content.text());
        }
        return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, content.emoji());
    }

    public String buildId() {
        ComponentManager componentManager = Utils.getComponentManager(this.context);
        return componentManager.putPersistentButton(this);
    }
}

