/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.components.builder.buttons;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.components.ButtonConsumer;
import com.freya02.botcommands.api.components.ComponentManager;
import com.freya02.botcommands.api.components.builder.AbstractLambdaComponentBuilder;
import com.freya02.botcommands.api.utils.ButtonContent;
import com.freya02.botcommands.internal.utils.Utils;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.dv8tion.jda.internal.interactions.component.ButtonImpl;

public class LambdaButtonBuilder
extends AbstractLambdaComponentBuilder<LambdaButtonBuilder> {
    private final BContext context;
    private final ButtonConsumer consumer;
    private final ButtonStyle buttonStyle;

    public LambdaButtonBuilder(BContext context, ButtonConsumer consumer, ButtonStyle buttonStyle) {
        this.context = context;
        this.consumer = consumer;
        this.buttonStyle = buttonStyle;
    }

    public ButtonConsumer getConsumer() {
        return this.consumer;
    }

    public Button build(String label) {
        return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, null).withLabel(label);
    }

    public Button build(Emoji emoji) {
        return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, emoji);
    }

    public Button build(ButtonContent content) {
        if (content.text() != null) {
            if (content.emoji() != null) {
                return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, content.emoji()).withLabel(content.text());
            }
            return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, null).withLabel(content.text());
        }
        return new ButtonImpl(this.buildId(), "", this.buttonStyle, false, content.emoji());
    }

    public String buildId() {
        ComponentManager componentManager = Utils.getComponentManager(this.context);
        return componentManager.putLambdaButton(this);
    }
}

