/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.components;

import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.components.ButtonConsumer;
import com.freya02.botcommands.api.components.ComponentConsumer;
import com.freya02.botcommands.api.components.ComponentErrorReason;
import com.freya02.botcommands.api.components.ComponentManager;
import com.freya02.botcommands.api.components.ComponentType;
import com.freya02.botcommands.api.components.FetchResult;
import com.freya02.botcommands.api.components.InteractionConstraints;
import com.freya02.botcommands.api.components.SelectionConsumer;
import com.freya02.botcommands.api.components.builder.ComponentBuilder;
import com.freya02.botcommands.api.components.builder.LambdaComponentTimeoutInfo;
import com.freya02.botcommands.api.components.builder.PersistentComponentBuilder;
import com.freya02.botcommands.api.components.builder.PersistentComponentTimeoutInfo;
import com.freya02.botcommands.api.components.builder.buttons.LambdaButtonBuilder;
import com.freya02.botcommands.api.components.builder.buttons.PersistentButtonBuilder;
import com.freya02.botcommands.api.components.builder.selects.LambdaSelectionMenuBuilder;
import com.freya02.botcommands.api.components.builder.selects.PersistentSelectionMenuBuilder;
import com.freya02.botcommands.internal.components.HandleComponentResult;
import com.freya02.botcommands.internal.components.data.LambdaButtonData;
import com.freya02.botcommands.internal.components.data.LambdaSelectionMenuData;
import com.freya02.botcommands.internal.components.data.PersistentButtonData;
import com.freya02.botcommands.internal.components.data.PersistentSelectionMenuData;
import com.freya02.botcommands.internal.components.sql.SQLComponentData;
import com.freya02.botcommands.internal.components.sql.SQLFetchResult;
import com.freya02.botcommands.internal.components.sql.SQLFetchedComponent;
import com.freya02.botcommands.internal.components.sql.SQLLambdaComponentData;
import com.freya02.botcommands.internal.components.sql.SQLLambdaCreateResult;
import com.freya02.botcommands.internal.components.sql.SQLPersistentComponentData;
import com.freya02.botcommands.internal.utils.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.events.interaction.component.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericSelectMenuInteractionEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DefaultComponentManager
implements ComponentManager {
    private static final Logger LOGGER = Logging.getLogger();
    private static final String LATEST_VERSION = "2";
    private final ScheduledExecutorService timeoutService = Executors.newSingleThreadScheduledExecutor();
    private final Supplier<Connection> connectionSupplier;
    private final Map<Long, ButtonConsumer> buttonLambdaMap = new HashMap<Long, ButtonConsumer>();
    private final Map<Long, SelectionConsumer<? extends GenericSelectMenuInteractionEvent<?, ?>>> selectionMenuLambdaMap = new HashMap();

    public DefaultComponentManager(@NotNull Supplier<Connection> connectionSupplier) {
        this.connectionSupplier = connectionSupplier;
        try {
            this.setupTables();
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create DefaultComponentManager", (Throwable)e);
            throw new RuntimeException("Unable to create DefaultComponentManager", e);
        }
    }

    @Override
    @NotNull
    public SQLFetchResult fetchComponent(String id) {
        Connection connection = this.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select * from componentdata left join lambdacomponentdata using (componentid) left join persistentcomponentdata using (componentid)where componentid = ? limit 1;");
            preparedStatement.setString(1, id);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return new SQLFetchResult(new SQLFetchedComponent(resultSet), connection);
            }
            return new SQLFetchResult(null, connection);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get the ID type of '{}'", (Object)id);
            return new SQLFetchResult(null, connection);
        }
    }

    @Override
    public void handleLambdaButton(GenericComponentInteractionCreateEvent event, FetchResult fetchResult, Consumer<ComponentErrorReason> onError, Consumer<LambdaButtonData> dataConsumer) {
        this.handleLambdaComponent(event, (SQLFetchResult)fetchResult, onError, dataConsumer, this.buttonLambdaMap, LambdaButtonData::new);
    }

    @Override
    public <E extends GenericSelectMenuInteractionEvent<?, ?>> void handleLambdaSelectMenu(GenericComponentInteractionCreateEvent event, FetchResult fetchResult, Consumer<ComponentErrorReason> onError, Consumer<LambdaSelectionMenuData<E>> dataConsumer) {
        this.handleLambdaComponent(event, (SQLFetchResult)fetchResult, onError, dataConsumer, this.selectionMenuLambdaMap, LambdaSelectionMenuData::new);
    }

    private <CONSUMER extends ComponentConsumer<EVENT>, EVENT extends GenericComponentInteractionCreateEvent, DATA> void handleLambdaComponent(GenericComponentInteractionCreateEvent event, SQLFetchResult fetchResult, Consumer<ComponentErrorReason> onError, Consumer<DATA> dataConsumer, Map<Long, CONSUMER> map, Function<CONSUMER, DATA> eventFunc) {
        try {
            ComponentConsumer consumer;
            SQLFetchedComponent fetchedComponent = fetchResult.getFetchedComponent();
            if (fetchedComponent == null) {
                throw new IllegalArgumentException("A null fetched component cannot be handled");
            }
            SQLLambdaComponentData data = SQLLambdaComponentData.fromFetchedComponent(fetchedComponent);
            HandleComponentResult result = this.handleComponentData(event, data);
            if (result.getErrorReason() != null) {
                onError.accept(result.getErrorReason());
                return;
            }
            long handlerId = data.getHandlerId();
            if (result.shouldDelete()) {
                try (Connection connection = this.getConnection();){
                    data.delete(connection);
                }
                consumer = (ComponentConsumer)map.remove(handlerId);
            } else {
                consumer = (ComponentConsumer)map.get(handlerId);
            }
            if (consumer == null) {
                throw new IllegalArgumentException("Could not find a consumer for handler id %s on component %s".formatted(handlerId, event.getComponentId()));
            }
            dataConsumer.accept(eventFunc.apply(consumer));
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while handling a lambda component", (Throwable)e);
            throw new RuntimeException("An exception occurred while handling a lambda component", e);
        }
    }

    @Override
    public void handlePersistentButton(GenericComponentInteractionCreateEvent event, FetchResult fetchResult, Consumer<ComponentErrorReason> onError, Consumer<PersistentButtonData> dataConsumer) {
        this.handlePersistentComponent(event, (SQLFetchResult)fetchResult, onError, dataConsumer, PersistentButtonData::new);
    }

    @Override
    public void handlePersistentSelectMenu(GenericComponentInteractionCreateEvent event, FetchResult fetchResult, Consumer<ComponentErrorReason> onError, Consumer<PersistentSelectionMenuData> dataConsumer) {
        this.handlePersistentComponent(event, (SQLFetchResult)fetchResult, onError, dataConsumer, PersistentSelectionMenuData::new);
    }

    private <DATA> void handlePersistentComponent(GenericComponentInteractionCreateEvent event, SQLFetchResult fetchResult, Consumer<ComponentErrorReason> onError, Consumer<DATA> dataConsumer, BiFunction<String, String[], DATA> dataFunction) {
        try {
            SQLFetchedComponent fetchedComponent = fetchResult.getFetchedComponent();
            if (fetchedComponent == null) {
                throw new IllegalArgumentException("A null fetched component cannot be handled");
            }
            SQLPersistentComponentData data = SQLPersistentComponentData.fromFetchedComponent(fetchedComponent);
            HandleComponentResult result = this.handleComponentData(event, data);
            if (result.getErrorReason() != null) {
                onError.accept(result.getErrorReason());
                return;
            }
            String handlerName = data.getHandlerName();
            String[] args = data.getArgs();
            if (result.shouldDelete()) {
                data.delete(fetchResult.getConnection());
            }
            dataConsumer.accept(dataFunction.apply(handlerName, args));
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while handling a persistent component", (Throwable)e);
            throw new RuntimeException("An exception occurred while handling a persistent component", e);
        }
    }

    private void scheduleLambdaTimeout(Map<Long, ?> map, LambdaComponentTimeoutInfo timeout, long handlerId, String componentId) {
        if (timeout.timeout() > 0L) {
            this.timeoutService.schedule(() -> {
                try (Connection connection = this.getConnection();){
                    SQLLambdaComponentData data = SQLLambdaComponentData.read(connection, componentId);
                    if (data != null) {
                        map.remove(handlerId);
                        data.delete(connection);
                        timeout.timeoutCallback().run();
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("An error occurred while deleting a lambda component after a timeout", (Throwable)e);
                }
            }, timeout.timeout(), timeout.timeoutUnit());
        }
    }

    @Override
    @NotNull
    public String putLambdaButton(LambdaButtonBuilder builder) {
        String string;
        block9: {
            Connection connection = this.getConnection();
            try {
                SQLLambdaCreateResult result = SQLLambdaComponentData.create(connection, ComponentType.LAMBDA_BUTTON, builder.isOneUse(), builder.getInteractionConstraints(), builder.getTimeout());
                this.buttonLambdaMap.put(result.handlerId(), builder.getConsumer());
                if (builder.getTimeout().timeout() > 0L) {
                    this.scheduleLambdaTimeout(this.buttonLambdaMap, builder.getTimeout(), result.handlerId(), result.componentId());
                }
                string = result.componentId();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("An exception occurred while registering a lambda component", (Throwable)e);
                    throw new RuntimeException("An exception occurred while registering a lambda component", e);
                }
            }
            connection.close();
        }
        return string;
    }

    @Override
    @NotNull
    public <E extends GenericSelectMenuInteractionEvent<?, ?>> String putLambdaSelectMenu(LambdaSelectionMenuBuilder<?, E> builder) {
        String string;
        block9: {
            Connection connection = this.getConnection();
            try {
                LambdaComponentTimeoutInfo timeout = builder.getTimeout();
                SQLLambdaCreateResult result = SQLLambdaComponentData.create(connection, ComponentType.LAMBDA_SELECTION_MENU, builder.isOneUse(), builder.getInteractionConstraints(), timeout);
                this.selectionMenuLambdaMap.put(result.handlerId(), builder.getConsumer());
                if (timeout.timeout() > 0L) {
                    this.scheduleLambdaTimeout(this.selectionMenuLambdaMap, timeout, result.handlerId(), result.componentId());
                }
                string = result.componentId();
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("An exception occurred while registering a lambda component", (Throwable)e);
                    throw new RuntimeException("An exception occurred while registering a lambda component", e);
                }
            }
            connection.close();
        }
        return string;
    }

    private void schedulePersistentTimeout(PersistentComponentTimeoutInfo timeout, String componentId) {
        if (timeout.timeout() > 0L) {
            this.timeoutService.schedule(() -> {
                try (Connection connection = this.getConnection();){
                    SQLPersistentComponentData data = SQLPersistentComponentData.read(connection, componentId);
                    if (data != null) {
                        data.delete(connection);
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("An error occurred while deleting a persistent component after a timeout", (Throwable)e);
                }
            }, timeout.timeout(), timeout.timeoutUnit());
        }
    }

    private <T extends ComponentBuilder<T> & PersistentComponentBuilder<T>> String putPersistentComponent(T builder, ComponentType type) {
        String string;
        block8: {
            Connection connection = this.getConnection();
            try {
                String componentId = SQLPersistentComponentData.create(connection, type, builder.isOneUse(), builder.getInteractionConstraints(), ((PersistentComponentBuilder<T>)builder).getTimeout(), ((PersistentComponentBuilder<T>)builder).getHandlerName(), ((PersistentComponentBuilder<T>)builder).getArgs());
                this.schedulePersistentTimeout(((PersistentComponentBuilder<T>)builder).getTimeout(), componentId);
                string = componentId;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("An exception occurred while registering a persistent component", (Throwable)e);
                    throw new RuntimeException("An exception occurred while registering a persistent component", e);
                }
            }
            connection.close();
        }
        return string;
    }

    @Override
    @NotNull
    public String putPersistentButton(PersistentButtonBuilder builder) {
        return this.putPersistentComponent(builder, ComponentType.PERSISTENT_BUTTON);
    }

    @Override
    @NotNull
    public <T extends PersistentSelectionMenuBuilder<T>> String putPersistentSelectMenu(T builder) {
        return this.putPersistentComponent(builder, ComponentType.PERSISTENT_SELECTION_MENU);
    }

    @Override
    public void registerGroup(Collection<String> ids) {
        try (Connection connection = this.getConnection();
             PreparedStatement updateGroupsStatement = connection.prepareStatement("select nextval('group_seq');\nupdate componentdata set groupid = currval('group_seq') where componentid = any(?);");){
            updateGroupsStatement.setArray(1, connection.createArrayOf("text", ids.toArray()));
            updateGroupsStatement.execute();
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while handling a lambda component", (Throwable)e);
            throw new RuntimeException("An exception occurred while handling a lambda component", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteIds(Collection<String> ids) {
        if (ids.isEmpty()) {
            return 0;
        }
        try (Connection connection = this.getConnection();){
            int n;
            block23: {
                Object[] idArray = ids.toArray();
                try (PreparedStatement preparedStatement = connection.prepareStatement("delete from lambdacomponentdata where componentid = any(?) returning handlerid;");){
                    preparedStatement.setArray(1, connection.createArrayOf("text", idArray));
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        long handlerId = resultSet.getLong("handlerId");
                        if (this.buttonLambdaMap.remove(handlerId) != null) continue;
                        this.selectionMenuLambdaMap.remove(handlerId);
                    }
                }
                preparedStatement = connection.prepareStatement("delete from componentdata where componentid = any(?);");
                try {
                    preparedStatement.setArray(1, connection.createArrayOf("text", idArray));
                    n = preparedStatement.executeUpdate();
                    if (preparedStatement == null) break block23;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while deleting components", (Throwable)e);
            throw new RuntimeException("An exception occurred while deleting components", e);
        }
    }

    @NotNull
    private Connection getConnection() {
        return this.connectionSupplier.get();
    }

    private void setupTables() throws SQLException {
        String setupVersionSql = Utils.readResource("setupVersion.sql");
        try (Connection connection = this.getConnection();
             PreparedStatement setupVersionStatement = connection.prepareStatement(setupVersionSql);
             PreparedStatement readVersionStatement = connection.prepareStatement("select version from version limit 1;");){
            setupVersionStatement.execute();
            ResultSet set = readVersionStatement.executeQuery();
            if (set.next()) {
                String currentVersion = set.getString("version");
                if (!currentVersion.equals(LATEST_VERSION)) {
                    this.askUpdate(connection, currentVersion);
                } else {
                    LOGGER.trace("Running version {} of the components database", (Object)currentVersion);
                }
            } else {
                try (PreparedStatement detectDbStatement = connection.prepareStatement("select table_name from information_schema.tables where table_name = 'componentdata' limit 1;");){
                    if (detectDbStatement.executeQuery().next()) {
                        this.askUpdate(connection, "1");
                    } else {
                        this.resetTables(connection);
                        LOGGER.trace("Running version {} of the components database", (Object)LATEST_VERSION);
                    }
                }
            }
            String setupSql = Utils.readResource("setup.sql");
            try (PreparedStatement setupStatement = connection.prepareStatement(setupSql);){
                setupStatement.execute();
            }
        }
    }

    private void askUpdate(Connection connection, String currentVersion) throws SQLException {
        LOGGER.warn("Database is at version {} but should be at version {}, do you wish to upgrade ?", (Object)currentVersion, (Object)LATEST_VERSION);
        LOGGER.warn("This will delete all the component tables, other tables are not modified.");
        LOGGER.warn("Enter 'yes' in order to continue, or anything else to abort");
        Scanner scanner = new Scanner(System.in);
        String line = scanner.nextLine();
        if (!line.equalsIgnoreCase("yes")) {
            LOGGER.error("Database is outdated, aborting");
            throw new IllegalStateException("Database is at version " + currentVersion + " but should be at version 2");
        }
        this.resetTables(connection);
    }

    private void resetTables(Connection connection) throws SQLException {
        try (PreparedStatement resetTablesStatement = connection.prepareStatement(Utils.readResource("resetTables.sql"));){
            resetTablesStatement.execute();
        }
    }

    @NotNull
    private HandleComponentResult handleComponentData(GenericComponentInteractionCreateEvent event, SQLComponentData data) {
        boolean oneUse = data.isOneUse() || data.getGroupId() > 0L;
        InteractionConstraints constraints = data.getInteractionConstraints();
        long expirationTimestamp = data.getExpirationTimestamp();
        if (expirationTimestamp > 0L && System.currentTimeMillis() > expirationTimestamp) {
            return new HandleComponentResult(ComponentErrorReason.EXPIRED, true);
        }
        boolean allowed = this.checkConstraints(event, constraints);
        if (!allowed) {
            return new HandleComponentResult(ComponentErrorReason.NOT_ALLOWED, false);
        }
        return new HandleComponentResult(null, oneUse);
    }

    private boolean checkConstraints(GenericComponentInteractionCreateEvent event, InteractionConstraints constraints) {
        if (constraints.isEmpty()) {
            return true;
        }
        if (constraints.getUserList().contains(event.getUser().getIdLong())) {
            return true;
        }
        Member member = event.getMember();
        if (member != null) {
            if (!constraints.getPermissions().isEmpty() && member.hasPermission((GuildChannel)event.getGuildChannel(), constraints.getPermissions())) {
                return true;
            }
            if (event.getGuild() != null && constraints.getRoleList().contains(event.getGuild().getIdLong())) {
                return true;
            }
            for (Role role : member.getRoles()) {
                boolean hasRole = constraints.getRoleList().contains(role.getIdLong());
                if (!hasRole) continue;
                return true;
            }
        }
        return false;
    }
}

