/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.components;

import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.components.ComponentErrorReason;
import com.freya02.botcommands.api.components.ComponentFilteringData;
import com.freya02.botcommands.api.components.ComponentInteractionFilter;
import com.freya02.botcommands.api.components.ComponentManager;
import com.freya02.botcommands.api.components.ComponentType;
import com.freya02.botcommands.api.components.Components;
import com.freya02.botcommands.api.components.FetchResult;
import com.freya02.botcommands.api.components.FetchedComponent;
import com.freya02.botcommands.api.components.event.ButtonEvent;
import com.freya02.botcommands.api.components.event.EntitySelectionEvent;
import com.freya02.botcommands.api.components.event.StringSelectionEvent;
import com.freya02.botcommands.api.parameters.ComponentParameterResolver;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.MethodParameters;
import com.freya02.botcommands.internal.RunnableEx;
import com.freya02.botcommands.internal.application.CommandParameter;
import com.freya02.botcommands.internal.components.ComponentDescriptor;
import com.freya02.botcommands.internal.components.ComponentHandlerParameter;
import com.freya02.botcommands.internal.utils.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import net.dv8tion.jda.api.events.Event;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.EntitySelectInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericSelectMenuInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.StringSelectInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.hooks.SubscribeEvent;
import net.dv8tion.jda.api.interactions.Interaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ComponentListener
extends ListenerAdapter {
    private static final Logger LOGGER = Logging.getLogger();
    private final ExecutorService idHandlingExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in a component ID handler thread '" + t.getName() + "':", e));
        thread.setName("Component ID handling thread");
        return thread;
    });
    private final BContextImpl context;
    private final ComponentManager componentManager;
    private final Map<String, ComponentDescriptor> buttonsMap;
    private final Map<String, ComponentDescriptor> selectionMenuMap;
    private int callbackThreadNumber;
    private final ExecutorService callbackExecutor = Utils.createCommandPool(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(false);
        thread.setUncaughtExceptionHandler((t, e) -> Utils.printExceptionString("An unexpected exception happened in a component callback thread '" + t.getName() + "':", e));
        thread.setName("Component callback thread #" + this.callbackThreadNumber++);
        return thread;
    });

    public ComponentListener(BContextImpl context, Map<String, ComponentDescriptor> buttonsMap, Map<String, ComponentDescriptor> selectionMenuMap) {
        this.context = context;
        this.componentManager = Utils.getComponentManager(context);
        this.buttonsMap = buttonsMap;
        this.selectionMenuMap = selectionMenuMap;
        Components.setContext(context);
    }

    @SubscribeEvent
    public void onGenericComponentInteractionCreate(@NotNull GenericComponentInteractionCreateEvent event) {
        if (!(event instanceof ButtonInteractionEvent) && !(event instanceof GenericSelectMenuInteractionEvent)) {
            return;
        }
        this.runHandler(() -> this.handleComponentInteraction(event), event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleComponentInteraction(@NotNull GenericComponentInteractionCreateEvent event) throws Exception {
        for (ComponentInteractionFilter componentFilter : this.context.getComponentFilters()) {
            if (componentFilter.isAccepted(new ComponentFilteringData(this.context, event))) continue;
            LOGGER.trace("Cancelled component interaction due to filter");
            return;
        }
        try (FetchResult fetchResult = this.componentManager.fetchComponent(event.getComponentId());){
            FetchedComponent fetchedComponent = fetchResult.getFetchedComponent();
            if (fetchedComponent == null) {
                event.reply(this.context.getDefaultMessages((Interaction)event).getComponentNotFoundErrorMsg()).setEphemeral(true).queue();
                return;
            }
            ComponentType idType = fetchedComponent.getType();
            if (!(idType != ComponentType.PERSISTENT_BUTTON && idType != ComponentType.LAMBDA_BUTTON || event instanceof ButtonInteractionEvent)) {
                LOGGER.error("Received a button id type but event is not a ButtonInteractionEvent");
                return;
            }
            if (!(idType != ComponentType.PERSISTENT_SELECTION_MENU && idType != ComponentType.LAMBDA_SELECTION_MENU || event instanceof GenericSelectMenuInteractionEvent)) {
                LOGGER.error("Received a selection menu id type but event is not a GenericSelectMenuInteractionEvent");
                return;
            }
            switch (idType) {
                case PERSISTENT_BUTTON: {
                    this.componentManager.handlePersistentButton(event, fetchResult, e -> this.onError(event, (ComponentErrorReason)((Object)e)), data -> this.runCallback(() -> this.handlePersistentComponent(event, this.buttonsMap, data.getHandlerName(), data.getArgs(), descriptor -> new ButtonEvent(descriptor.getMethod(), this.context, (ButtonInteractionEvent)event)), event));
                    return;
                }
                case LAMBDA_BUTTON: {
                    this.componentManager.handleLambdaButton(event, fetchResult, e -> this.onError(event, (ComponentErrorReason)((Object)e)), data -> this.runCallback(() -> data.getConsumer().accept(new ButtonEvent(null, this.context, (ButtonInteractionEvent)event)), event));
                    return;
                }
                case PERSISTENT_SELECTION_MENU: {
                    this.componentManager.handlePersistentSelectMenu(event, fetchResult, e -> this.onError(event, (ComponentErrorReason)((Object)e)), data -> this.runCallback(() -> this.handlePersistentComponent(event, this.selectionMenuMap, data.getHandlerName(), data.getArgs(), descriptor -> this.transformSelectEvent(descriptor.getMethod(), this.context, event)), event));
                    return;
                }
                case LAMBDA_SELECTION_MENU: {
                    this.componentManager.handleLambdaSelectMenu(event, fetchResult, e -> this.onError(event, (ComponentErrorReason)((Object)e)), data -> this.runCallback(() -> data.getConsumer().accept(this.transformSelectEvent(null, this.context, event)), event));
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unknown id type: " + idType.name());
                }
            }
        }
    }

    private void runHandler(RunnableEx code, @NotNull GenericComponentInteractionCreateEvent event) {
        this.idHandlingExecutor.execute(() -> {
            try {
                long start = System.nanoTime();
                code.run();
                long end = System.nanoTime();
                LOGGER.trace("Component handler took {} ms", (Object)((double)(end - start) / 1000000.0));
            }
            catch (Throwable e) {
                ExceptionHandler handler = this.context.getUncaughtExceptionHandler();
                if (handler != null) {
                    handler.onException(this.context, (Event)event, e);
                    return;
                }
                Throwable baseEx = Utils.getException(e);
                Utils.printExceptionString("Unhandled exception in thread '" + Thread.currentThread().getName() + "' while executing the component ID handler", baseEx);
                if (event.isAcknowledged()) {
                    event.getHook().sendMessage(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
                } else {
                    event.reply(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
                }
                this.context.dispatchException("Exception in component ID handler", baseEx);
            }
        });
    }

    private void runCallback(RunnableEx code, @NotNull GenericComponentInteractionCreateEvent event) {
        this.callbackExecutor.execute(() -> {
            try {
                long start = System.nanoTime();
                code.run();
                long end = System.nanoTime();
                LOGGER.trace("Component callback took {} ms", (Object)((double)(end - start) / 1000000.0));
            }
            catch (Throwable e) {
                ExceptionHandler handler = this.context.getUncaughtExceptionHandler();
                if (handler != null) {
                    handler.onException(this.context, (Event)event, e);
                    return;
                }
                Throwable baseEx = Utils.getException(e);
                Utils.printExceptionString("Unhandled exception in thread '" + Thread.currentThread().getName() + "' while executing a component callback", baseEx);
                if (event.isAcknowledged()) {
                    event.getHook().sendMessage(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
                } else {
                    event.reply(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
                }
                this.context.dispatchException("Exception in component callback", baseEx);
            }
        });
    }

    @NotNull
    private GenericSelectMenuInteractionEvent<?, ?> transformSelectEvent(@Nullable Method method, BContextImpl context, GenericComponentInteractionCreateEvent event) {
        if (event instanceof StringSelectInteractionEvent) {
            StringSelectInteractionEvent stringSelectEvent = (StringSelectInteractionEvent)event;
            return new StringSelectionEvent(method, context, stringSelectEvent);
        }
        if (event instanceof EntitySelectInteractionEvent) {
            EntitySelectInteractionEvent entitySelectEvent = (EntitySelectInteractionEvent)event;
            return new EntitySelectionEvent(null, context, entitySelectEvent);
        }
        throw new IllegalArgumentException("Invalid select menu type: " + event.getClass().getName());
    }

    private void handlePersistentComponent(GenericComponentInteractionCreateEvent event, Map<String, ComponentDescriptor> map, String handlerName, String[] args, Function<ComponentDescriptor, ? extends GenericComponentInteractionCreateEvent> eventFunction) {
        ComponentDescriptor descriptor = map.get(handlerName);
        if (descriptor == null) {
            LOGGER.error("No component descriptor found for component handler '{}'", (Object)handlerName);
            return;
        }
        MethodParameters<ComponentHandlerParameter> parameters = descriptor.getParameters();
        if (parameters.getOptionCount() != args.length) {
            throw new IllegalArgumentException("Resolver for %s has %d arguments but component had %d data objects".formatted(Utils.formatMethodShort(descriptor.getMethod()), parameters.size(), args.length));
        }
        Consumer<Throwable> throwableConsumer = this.getThrowableConsumer(event, handlerName, args);
        try {
            ArrayList<Object> methodArgs = new ArrayList<Object>(parameters.size() + 1);
            methodArgs.add(eventFunction.apply(descriptor));
            int optionIndex = 0;
            for (CommandParameter commandParameter : parameters) {
                Object obj;
                if (commandParameter.isOption()) {
                    String arg = args[optionIndex];
                    ++optionIndex;
                    obj = ((ComponentParameterResolver)commandParameter.getResolver()).resolve(this.context, descriptor, event, arg);
                    if (obj == null) {
                        throw new IllegalArgumentException("Component id '%s', tried to resolve '%s' with an option resolver %s on method %s but result is null".formatted(event.getComponentId(), arg, commandParameter.getCustomResolver().getClass().getSimpleName(), Utils.formatMethodShort(descriptor.getMethod())));
                    }
                } else {
                    obj = commandParameter.getCustomResolver().resolve(this.context, descriptor, (Event)event);
                    if (obj == null) {
                        throw new IllegalArgumentException("Component id '%s', tried to use custom resolver %s on method %s but result is null".formatted(event.getComponentId(), commandParameter.getCustomResolver().getClass().getSimpleName(), Utils.formatMethodShort(descriptor.getMethod())));
                    }
                }
                methodArgs.add(obj);
            }
            descriptor.getMethodRunner().invoke(methodArgs.toArray(), throwableConsumer);
        }
        catch (Exception e) {
            throwableConsumer.accept(e);
        }
    }

    @NotNull
    private Consumer<Throwable> getThrowableConsumer(GenericComponentInteractionCreateEvent event, String handlerName, String[] args) {
        return e -> {
            ExceptionHandler handler = this.context.getUncaughtExceptionHandler();
            if (handler != null) {
                handler.onException(this.context, (Event)event, (Throwable)e);
                return;
            }
            Throwable baseEx = Utils.getException(e);
            LOGGER.error("An exception occurred while handling a persistent component '{}' with args {}", new Object[]{handlerName, Arrays.toString(args), e});
            if (event.isAcknowledged()) {
                event.getHook().sendMessage(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
            } else {
                event.reply(this.context.getDefaultMessages((Interaction)event).getGeneralErrorMsg()).setEphemeral(true).queue();
            }
            this.context.dispatchException("Exception in persistent component handler", baseEx);
        };
    }

    private void onError(GenericComponentInteractionCreateEvent event, ComponentErrorReason reason) {
        event.reply(reason.getReason(this.context.getDefaultMessages((Interaction)event))).setEphemeral(true).queue();
    }
}

