/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.builder;

import com.freya02.botcommands.api.application.ApplicationCommandFilter;
import com.freya02.botcommands.api.components.ComponentInteractionFilter;
import com.freya02.botcommands.internal.BContextImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import org.jetbrains.annotations.NotNull;

public class ApplicationCommandsBuilder {
    private final BContextImpl context;
    private final List<Long> slashGuildIds = new ArrayList<Long>();

    public ApplicationCommandsBuilder(BContextImpl context) {
        this.context = context;
    }

    public List<Long> getSlashGuildIds() {
        return this.slashGuildIds;
    }

    @NotNull
    public ApplicationCommandsBuilder addApplicationFilter(@NotNull ApplicationCommandFilter commandFilter) {
        this.context.addApplicationFilter(commandFilter);
        return this;
    }

    @NotNull
    public ApplicationCommandsBuilder addComponentFilter(@NotNull ComponentInteractionFilter componentFilter) {
        this.context.addComponentFilter(componentFilter);
        return this;
    }

    public ApplicationCommandsBuilder updateCommandsOnGuildIds(List<Long> slashGuildIds) {
        this.slashGuildIds.clear();
        this.slashGuildIds.addAll(slashGuildIds);
        return this;
    }

    public ApplicationCommandsBuilder addTestGuilds(long ... guildIds) {
        this.context.addTestGuildIds(guildIds);
        return this;
    }

    public ApplicationCommandsBuilder enableOnlineAppCommandCheck() {
        this.context.enableOnlineAppCommandCheck();
        return this;
    }

    public ApplicationCommandsBuilder forceCommandsAsGuildOnly(boolean force) {
        this.context.getApplicationCommandsContext().setForceGuildCommands(force);
        return this;
    }

    public ApplicationCommandsBuilder addLocalizations(@NotNull String bundleName, DiscordLocale ... locales) {
        return this.addLocalizations(bundleName, Arrays.asList(locales));
    }

    public ApplicationCommandsBuilder addLocalizations(@NotNull String bundleName, @NotNull @NotNull List<@NotNull DiscordLocale> locales) {
        this.context.getApplicationCommandsContext().addLocalizations(bundleName, locales);
        return this;
    }
}

