/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api.application;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.CommandStatus;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.SettingsProvider;
import com.freya02.botcommands.api.application.CommandPath;
import com.freya02.botcommands.api.application.CommandScope;
import com.freya02.botcommands.internal.application.ApplicationCommandInfo;
import com.freya02.botcommands.internal.application.CommandIdProcessor;
import com.freya02.botcommands.internal.application.CommandInfoMap;
import com.freya02.botcommands.internal.application.context.message.MessageCommandInfo;
import com.freya02.botcommands.internal.application.context.user.UserCommandInfo;
import com.freya02.botcommands.internal.application.slash.SlashCommandInfo;
import com.freya02.botcommands.internal.utils.AnnotationUtils;
import gnu.trove.set.TLongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.Command;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;

public abstract class ApplicationCommandInfoMapView {
    private static final Logger LOGGER = Logging.getLogger();
    protected final Map<Command.Type, CommandInfoMap<? extends ApplicationCommandInfo>> typeMap = Collections.synchronizedMap(new EnumMap(Command.Type.class));

    public @UnmodifiableView Collection<? extends ApplicationCommandInfo> getAllApplicationCommandsView() {
        return this.typeMap.values().stream().flatMap(map -> map.values().stream()).toList();
    }

    public Stream<? extends ApplicationCommandInfo> getAllApplicationCommandsStream() {
        return this.typeMap.values().stream().flatMap(map -> map.values().stream());
    }

    public ApplicationCommandInfo get(Command.Type type, CommandPath path) {
        return this.getTypeMap(type).get(path);
    }

    public @UnmodifiableView CommandInfoMap<SlashCommandInfo> getSlashCommandsView() {
        CommandInfoMap typeMap = this.getTypeMap(Command.Type.SLASH);
        return typeMap.unmodifiable();
    }

    public @UnmodifiableView CommandInfoMap<UserCommandInfo> getUserCommandsView() {
        CommandInfoMap map = this.getTypeMap(Command.Type.USER);
        return map.unmodifiable();
    }

    public @UnmodifiableView CommandInfoMap<MessageCommandInfo> getMessageCommandsView() {
        CommandInfoMap map = this.getTypeMap(Command.Type.MESSAGE);
        return map.unmodifiable();
    }

    @Nullable
    public SlashCommandInfo findSlashCommand(@NotNull CommandPath path) {
        return (SlashCommandInfo)this.getSlashCommandsView().get(path);
    }

    @Nullable
    public UserCommandInfo findUserCommand(@NotNull String name) {
        return (UserCommandInfo)this.getUserCommandsView().get(CommandPath.ofName(name));
    }

    @Nullable
    public MessageCommandInfo findMessageCommand(@NotNull String name) {
        return (MessageCommandInfo)this.getMessageCommandsView().get(CommandPath.ofName(name));
    }

    protected <T extends ApplicationCommandInfo> CommandInfoMap<T> getTypeMap(Command.Type type) {
        return this.typeMap.computeIfAbsent(type, x -> new CommandInfoMap());
    }

    public List<ApplicationCommandInfo> filterByGuild(@NotNull BContext context, @Nullable Guild guild, @Nullable CommandIdProcessor commandIdProcessor) {
        return this.getAllApplicationCommandsStream().filter(info -> {
            CommandStatus commandStatus;
            TLongSet effectiveTestGuildIds;
            if (info.getScope() == CommandScope.GUILD && guild == null) {
                return false;
            }
            if (info.getScope() != CommandScope.GUILD && guild != null) {
                return false;
            }
            if (guild == null) {
                return true;
            }
            if (info.isTestOnly() && !(effectiveTestGuildIds = AnnotationUtils.getEffectiveTestGuildIds(context, info.getMethod())).contains(guild.getIdLong())) {
                return false;
            }
            if (commandIdProcessor == null) {
                throw new IllegalArgumentException("Command ID processor should not be null if guild isn't null");
            }
            String commandId = info.getCommandId();
            if (commandId != null && (commandStatus = commandIdProcessor.getStatus(info.getPath(), commandId, guild.getIdLong())) == CommandStatus.DISABLED) {
                return false;
            }
            SettingsProvider settingsProvider = context.getSettingsProvider();
            if (settingsProvider == null) {
                return true;
            }
            return settingsProvider.getGuildCommands(guild).getFilter().test(info.getPath());
        }).sorted(Comparator.comparingInt(info -> info.getPath().getNameCount())).collect(Collectors.toCollection(ArrayList::new));
    }
}

