/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api;

import com.freya02.botcommands.api.BContext;
import com.freya02.botcommands.api.ExceptionHandler;
import com.freya02.botcommands.api.Logging;
import com.freya02.botcommands.api.RegistrationListener;
import com.freya02.botcommands.api.SettingsProvider;
import com.freya02.botcommands.api.application.ApplicationCommand;
import com.freya02.botcommands.api.builder.ApplicationCommandsBuilder;
import com.freya02.botcommands.api.builder.DebugBuilder;
import com.freya02.botcommands.api.builder.ExtensionsBuilder;
import com.freya02.botcommands.api.builder.TextCommandsBuilder;
import com.freya02.botcommands.api.components.ComponentManager;
import com.freya02.botcommands.api.prefixed.TextCommand;
import com.freya02.botcommands.internal.BContextImpl;
import com.freya02.botcommands.internal.CommandsBuilderImpl;
import com.freya02.botcommands.internal.utils.Utils;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dv8tion.jda.annotations.ReplaceWith;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class CommandsBuilder {
    private static final Logger LOGGER = Logging.getLogger();
    private final BContextImpl context = new BContextImpl();
    private final Set<String> packageNames = new HashSet<String>();
    private final Set<Class<?>> manualClasses = new HashSet();
    private final TextCommandsBuilder textCommandBuilder = new TextCommandsBuilder(this.context);
    private final ApplicationCommandsBuilder applicationCommandBuilder = new ApplicationCommandsBuilder(this.context);
    private final ExtensionsBuilder extensionsBuilder = new ExtensionsBuilder(this.context);
    private final DebugBuilder debugBuilder = new DebugBuilder();

    private CommandsBuilder() {
    }

    public static CommandsBuilder newBuilder(long topOwnerId) {
        return new CommandsBuilder().addOwners(topOwnerId);
    }

    public static CommandsBuilder newBuilder() {
        return new CommandsBuilder();
    }

    public CommandsBuilder addOwners(long ... ownerIds) {
        for (long ownerId : ownerIds) {
            this.context.addOwner(ownerId);
        }
        return this;
    }

    public CommandsBuilder setDefaultEmbedFunction(@NotNull Supplier<EmbedBuilder> defaultEmbedFunction, @NotNull Supplier<InputStream> defaultFooterIconSupplier) {
        this.context.setDefaultEmbedSupplier(defaultEmbedFunction);
        this.context.setDefaultFooterIconSupplier(defaultFooterIconSupplier);
        return this;
    }

    public CommandsBuilder setSettingsProvider(SettingsProvider provider) {
        this.context.setSettingsProvider(Objects.requireNonNull(provider, "Settings provider cannot be null"));
        return this;
    }

    public CommandsBuilder setUncaughtExceptionHandler(@Nullable ExceptionHandler exceptionHandler) {
        this.context.setUncaughtExceptionHandler(exceptionHandler);
        return this;
    }

    public CommandsBuilder setComponentManager(ComponentManager componentManager) {
        this.context.setComponentManager(Objects.requireNonNull(componentManager, "Component manager cannot be null"));
        return this;
    }

    public CommandsBuilder addRegistrationListeners(RegistrationListener ... listeners) {
        this.context.addRegistrationListeners(listeners);
        return this;
    }

    @Deprecated
    @ReplaceWith(value="registerClass(clazz)")
    public CommandsBuilder registerCommand(Class<?> clazz) {
        if (!TextCommand.class.isAssignableFrom(clazz) && !ApplicationCommand.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("You can't register a class that's not a TextCommand or an ApplicationCommand, provided: " + clazz.getName());
        }
        this.manualClasses.add(clazz);
        return this;
    }

    public CommandsBuilder registerClass(Class<?> clazz) {
        this.manualClasses.add(clazz);
        return this;
    }

    public CommandsBuilder addSearchPath(String commandPackageName) {
        Utils.requireNonBlank(commandPackageName, "Command package");
        this.packageNames.add(commandPackageName);
        return this;
    }

    public CommandsBuilder extensionsBuilder(Consumer<ExtensionsBuilder> consumer) {
        consumer.accept(this.extensionsBuilder);
        return this;
    }

    public CommandsBuilder textCommandBuilder(Consumer<TextCommandsBuilder> consumer) {
        consumer.accept(this.textCommandBuilder);
        return this;
    }

    public CommandsBuilder applicationCommandBuilder(@NotNull @NotNull Consumer<@NotNull ApplicationCommandsBuilder> consumer) {
        consumer.accept(this.applicationCommandBuilder);
        return this;
    }

    public CommandsBuilder debugBuilder(@NotNull @NotNull Consumer<@NotNull DebugBuilder> consumer) {
        consumer.accept(this.debugBuilder);
        return this;
    }

    @Blocking
    public void build(JDA jda, @NotNull String commandPackageName) {
        this.addSearchPath(commandPackageName);
        this.build(jda);
    }

    @Blocking
    public void build(JDA jda) {
        try {
            new CommandsBuilderImpl(this.context, this.packageNames, this.manualClasses, this.applicationCommandBuilder.getSlashGuildIds()).build(jda);
        }
        catch (RuntimeException e) {
            LOGGER.error("An error occurred while creating the framework, aborted");
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while creating the framework, aborted");
            throw new RuntimeException(e);
        }
    }

    public BContext getContext() {
        return this.context;
    }
}

