/*
 * Decompiled with CFR 0.152.
 */
package com.freya02.botcommands.api;

import com.freya02.botcommands.api.application.CommandPath;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CommandList {
    private final Predicate<CommandPath> filter;

    private CommandList(Predicate<CommandPath> filter) {
        this.filter = filter;
    }

    public static CommandList of(Collection<String> enabledCommandsStrs) {
        List enabledCommands = enabledCommandsStrs.stream().map(CommandPath::of).collect(Collectors.toList());
        return new CommandList(path -> CommandList.containsCommand(enabledCommands, path));
    }

    private static boolean containsCommand(List<CommandPath> commandOrGroupPaths, CommandPath path) {
        for (CommandPath commandOrGroupPath : commandOrGroupPaths) {
            if (!path.startsWith(commandOrGroupPath)) continue;
            return true;
        }
        return false;
    }

    public static CommandList notOf(Collection<String> disabledCommandsStrs) {
        List disabledCommands = disabledCommandsStrs.stream().map(CommandPath::of).collect(Collectors.toList());
        return new CommandList(path -> !CommandList.containsCommand(disabledCommands, path));
    }

    public static CommandList none() {
        return new CommandList(s -> false);
    }

    public static CommandList all() {
        return new CommandList(s -> true);
    }

    public static CommandList filter(Predicate<CommandPath> predicate) {
        return new CommandList(predicate);
    }

    public Predicate<CommandPath> getFilter() {
        return this.filter;
    }
}

