/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwgiz.log4j.maven.plugins.shade.transformer;

import io.github.edwgiz.log4j.maven.plugins.shade.transformer.CloseShieldOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;

public class Log4j2PluginCacheFileTransformer
implements ReproducibleResourceTransformer {
    private final List<Path> tempFiles;
    private final List<Relocator> tempRelocators = new ArrayList<Relocator>();
    private long youngestTime = 0L;

    public Log4j2PluginCacheFileTransformer() {
        this.tempFiles = new ArrayList<Path>();
    }

    public boolean canTransformResource(String resource) {
        return "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat".equals(resource);
    }

    @Deprecated
    public void processResource(String resource, InputStream is, List<Relocator> relocators) {
    }

    public void processResource(String resource, InputStream resourceInput, List<Relocator> relocators, long time) throws IOException {
        Path tempFile = Files.createTempFile("Log4j2Plugins", "dat", new FileAttribute[0]);
        Files.copy(resourceInput, tempFile, StandardCopyOption.REPLACE_EXISTING);
        this.tempFiles.add(tempFile);
        this.youngestTime = Math.max(this.youngestTime, time);
        if (relocators != null) {
            this.tempRelocators.addAll(relocators);
        }
    }

    public boolean hasTransformedResource() {
        return this.tempFiles.size() > 1 || !this.tempFiles.isEmpty() && !this.tempRelocators.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        try {
            PluginCache aggregator = new PluginCache();
            aggregator.loadCacheFiles(this.getUrls());
            this.relocatePlugin(this.tempRelocators, aggregator.getAllCategories());
            JarEntry jarEntry = new JarEntry("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat");
            FileTime fileTime = FileTime.fromMillis(this.youngestTime);
            jarEntry.setLastModifiedTime(fileTime);
            jos.putNextEntry(jarEntry);
            CloseShieldOutputStream outputStream = new CloseShieldOutputStream(jos);
            aggregator.writeCache((OutputStream)((Object)outputStream));
        }
        finally {
            ListIterator<Path> pathIterator = this.tempFiles.listIterator();
            while (pathIterator.hasNext()) {
                Path path = pathIterator.next();
                Files.deleteIfExists(path);
                pathIterator.remove();
            }
        }
    }

    void relocatePlugin(List<Relocator> relocators, Map<String, Map<String, PluginEntry>> aggregatorCategories) {
        for (Map.Entry<String, Map<String, PluginEntry>> categoryEntry : aggregatorCategories.entrySet()) {
            for (Map.Entry<String, PluginEntry> pluginMapEntry : categoryEntry.getValue().entrySet()) {
                PluginEntry pluginEntry = pluginMapEntry.getValue();
                String originalClassName = pluginEntry.getClassName();
                Relocator matchingRelocator = this.findFirstMatchingRelocator(originalClassName, relocators);
                if (matchingRelocator == null) continue;
                String newClassName = matchingRelocator.relocateClass(originalClassName);
                pluginEntry.setClassName(newClassName);
            }
        }
    }

    private Relocator findFirstMatchingRelocator(String originalClassName, List<Relocator> relocators) {
        Relocator result = null;
        for (Relocator relocator : relocators) {
            if (!relocator.canRelocateClass(originalClassName)) continue;
            result = relocator;
        }
        return result;
    }

    private Enumeration<URL> getUrls() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Path tempFile : this.tempFiles) {
            URL url = tempFile.toUri().toURL();
            urls.add(url);
        }
        return Collections.enumeration(urls);
    }
}

