/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.warlordspartymanager.party;

import com.ebicep.chatutils.ChatUtils;
import com.ebicep.warlords.poll.polls.PartyPoll;
import com.ebicep.warlordspartymanager.RegularGamesMenu;
import com.ebicep.warlordspartymanager.WarlordsPartyManager;
import com.ebicep.warlordspartymanager.party.PartyPlayer;
import com.ebicep.warlordspartymanager.party.PartyPlayerType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Party {
    private final List<PartyPlayer> partyPlayers = new ArrayList<PartyPlayer>();
    private final List<PartyPoll> polls = new ArrayList<PartyPoll>();
    private final HashMap<UUID, Integer> invites = new HashMap();
    private final BukkitTask partyTask;
    private final RegularGamesMenu regularGamesMenu = new RegularGamesMenu(this);
    private boolean open = false;
    private boolean allInvite = false;

    public Party(UUID leader, boolean open) {
        this.partyPlayers.add(new PartyPlayer(leader, PartyPlayerType.LEADER));
        this.open = open;
        this.partyTask = new BukkitRunnable(){

            public void run() {
                Party.this.invites.forEach((uuid, integer) -> Party.this.invites.put(uuid, integer - 1));
                Party.this.invites.entrySet().removeIf(invite -> {
                    if ((Integer)invite.getValue() <= 0) {
                        Party.this.sendMessageToAllPartyPlayers(ChatColor.RED + "The party invite to " + ChatColor.AQUA + Bukkit.getOfflinePlayer((UUID)((UUID)invite.getKey())).getName() + ChatColor.RED + " has expired!", ChatColor.BLUE, true);
                    }
                    return (Integer)invite.getValue() <= 0;
                });
                for (int i = 0; i < Party.this.partyPlayers.size(); ++i) {
                    PartyPlayer partyPlayer = (PartyPlayer)Party.this.partyPlayers.get(i);
                    if (partyPlayer == null || partyPlayer.getOfflineTimeLeft() == -1) continue;
                    int offlineTimeLeft = partyPlayer.getOfflineTimeLeft();
                    partyPlayer.setOfflineTimeLeft(offlineTimeLeft - 1);
                    if (offlineTimeLeft == 0) {
                        Party.this.leave(partyPlayer.getUuid());
                        --i;
                        continue;
                    }
                    if (offlineTimeLeft % 60 != 0) continue;
                    Party.this.sendMessageToAllPartyPlayers(ChatColor.AQUA + Bukkit.getOfflinePlayer((UUID)partyPlayer.getUuid()).getName() + ChatColor.YELLOW + " has " + ChatColor.RED + offlineTimeLeft / 60 + ChatColor.YELLOW + " minutes to rejoin before getting kicked!", ChatColor.BLUE, true);
                }
            }
        }.runTaskTimer((Plugin)WarlordsPartyManager.getWarlordsPartyManager(), 0L, 20L);
    }

    public void invite(String name) {
        Player player = Bukkit.getPlayer((String)name);
        this.invites.put(player.getUniqueId(), 60);
    }

    public void join(UUID uuid) {
        this.invites.remove(uuid);
        this.partyPlayers.add(new PartyPlayer(uuid, PartyPlayerType.MEMBER));
        Player player = Bukkit.getPlayer((UUID)uuid);
        this.sendMessageToAllPartyPlayers(ChatColor.AQUA + player.getName() + ChatColor.GREEN + " joined the party", ChatColor.BLUE, true);
        if (player.hasPermission("warlords.party.automoderator")) {
            this.promote(Bukkit.getOfflinePlayer((UUID)uuid).getName());
        }
        Bukkit.getPlayer((UUID)uuid).sendMessage(this.getPartyList());
    }

    public void leave(UUID uuid) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        PartyPlayer partyPlayer = this.getPartyPlayerByUUID(uuid);
        if (partyPlayer == null) {
            return;
        }
        this.partyPlayers.remove(partyPlayer);
        if (partyPlayer.getPartyPlayerType() == PartyPlayerType.LEADER) {
            if (this.partyPlayers.isEmpty()) {
                if (partyPlayer.isOnline()) {
                    ChatUtils.sendMessageToPlayer(player.getPlayer(), ChatColor.RED + "The party was disbanded", ChatColor.BLUE, true);
                }
                this.disband();
            } else {
                PartyPlayer playerToPromote = this.partyPlayers.stream().filter(p -> p.getPartyPlayerType() == PartyPlayerType.MODERATOR).findFirst().orElse(this.partyPlayers.get(0));
                playerToPromote.setPartyPlayerType(PartyPlayerType.LEADER);
                this.sendMessageToAllPartyPlayers(ChatColor.AQUA + player.getName() + ChatColor.RED + " left the party", ChatColor.BLUE, true);
                this.sendMessageToAllPartyPlayers(ChatColor.AQUA + Bukkit.getOfflinePlayer((UUID)playerToPromote.getUuid()).getName() + ChatColor.GREEN + " is now the new party leader", ChatColor.BLUE, true);
            }
        } else {
            this.sendMessageToAllPartyPlayers(ChatColor.AQUA + player.getName() + ChatColor.RED + " left the party", ChatColor.BLUE, true);
        }
    }

    public void transfer(String name) {
        this.partyPlayers.stream().filter(partyPlayer -> Bukkit.getOfflinePlayer((UUID)partyPlayer.getUuid()).getName().equalsIgnoreCase(name)).findFirst().ifPresent(partyPlayer -> {
            this.getPartyLeader().setPartyPlayerType(PartyPlayerType.MODERATOR);
            partyPlayer.setPartyPlayerType(PartyPlayerType.LEADER);
            String newLeaderName = Bukkit.getOfflinePlayer((UUID)partyPlayer.getUuid()).getName();
            this.sendMessageToAllPartyPlayers(ChatColor.GREEN + "The party was transferred to " + ChatColor.AQUA + newLeaderName, ChatColor.BLUE, true);
        });
    }

    public void remove(String name) {
        this.partyPlayers.stream().filter(partyPlayer -> Bukkit.getOfflinePlayer((UUID)partyPlayer.getUuid()).getName().equalsIgnoreCase(name)).findFirst().ifPresent(partyPlayer -> {
            this.partyPlayers.remove(partyPlayer);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)partyPlayer.getUuid());
            this.sendMessageToAllPartyPlayers(ChatColor.AQUA + offlinePlayer.getName() + ChatColor.RED + " was removed from the party", ChatColor.BLUE, true);
            if (offlinePlayer.isOnline()) {
                ChatUtils.sendMessageToPlayer(offlinePlayer.getPlayer(), ChatColor.RED + "You were removed from the party", ChatColor.BLUE, true);
            }
        });
    }

    public void disband() {
        WarlordsPartyManager.disbandParty(this);
        this.sendMessageToAllPartyPlayers(ChatColor.DARK_RED + "The party was disbanded", ChatColor.BLUE, true);
        this.partyTask.cancel();
    }

    public String getPartyList() {
        List<PartyPlayer> members;
        PartyPlayer leader = this.getPartyLeader();
        StringBuilder stringBuilder = new StringBuilder(ChatColor.BLUE + "-----------------------------\n").append(ChatColor.GOLD).append("Party Members (").append(this.partyPlayers.size()).append(")\n \n").append(ChatColor.YELLOW).append("Party Leader: ").append(ChatColor.AQUA).append(Bukkit.getOfflinePlayer((UUID)leader.getUuid()).getName()).append(leader.getPartyListDot()).append("\n");
        List<PartyPlayer> moderators = this.getPartyModerators();
        if (!moderators.isEmpty()) {
            stringBuilder.append(ChatColor.YELLOW).append("Party Moderators: ").append(ChatColor.AQUA);
            moderators.forEach(partyPlayer -> stringBuilder.append(ChatColor.AQUA).append(Bukkit.getOfflinePlayer((UUID)partyPlayer.getUuid()).getName()).append(partyPlayer.getPartyListDot()));
            stringBuilder.append("\n");
        }
        if (!(members = this.getPartyMembers()).isEmpty()) {
            stringBuilder.append(ChatColor.YELLOW).append("Party Members: ").append(ChatColor.AQUA);
            members.forEach(partyPlayer -> stringBuilder.append(ChatColor.AQUA).append(Bukkit.getOfflinePlayer((UUID)partyPlayer.getUuid()).getName()).append(partyPlayer.getPartyListDot()));
        }
        stringBuilder.append(ChatColor.BLUE).append("\n-----------------------------");
        return stringBuilder.toString();
    }

    public void afk(UUID uuid) {
        this.partyPlayers.stream().filter(partyPlayer -> partyPlayer.getUuid().equals(uuid)).findFirst().ifPresent(partyPlayer -> {
            partyPlayer.setAFK(!partyPlayer.isAFK());
            if (partyPlayer.isAFK()) {
                this.sendMessageToAllPartyPlayers(ChatColor.AQUA + Bukkit.getOfflinePlayer((UUID)uuid).getName() + ChatColor.RED + " is now AFK", ChatColor.BLUE, true);
            } else {
                this.sendMessageToAllPartyPlayers(ChatColor.AQUA + Bukkit.getOfflinePlayer((UUID)uuid).getName() + ChatColor.GREEN + " is no longer AFK", ChatColor.BLUE, true);
            }
        });
    }

    public void promote(String name) {
        UUID uuid = Bukkit.getOfflinePlayer((String)name).getUniqueId();
        if (this.getPartyModerators().stream().anyMatch(partyPlayer -> partyPlayer.getUuid().equals(uuid))) {
            this.transfer(name);
        } else {
            this.partyPlayers.stream().filter(partyPlayer -> partyPlayer.getUuid().equals(uuid)).findFirst().ifPresent(partyPlayer -> partyPlayer.setPartyPlayerType(PartyPlayerType.MODERATOR));
            this.sendMessageToAllPartyPlayers(ChatColor.AQUA + Bukkit.getOfflinePlayer((UUID)uuid).getName() + ChatColor.YELLOW + " was promoted to Party Moderator", ChatColor.BLUE, true);
        }
    }

    public void demote(String name) {
        this.partyPlayers.stream().filter(partyPlayer -> Bukkit.getOfflinePlayer((String)name).getUniqueId().equals(partyPlayer.getUuid())).findFirst().ifPresent(partyPlayer -> {
            if (partyPlayer.getPartyPlayerType() == PartyPlayerType.MODERATOR) {
                partyPlayer.setPartyPlayerType(PartyPlayerType.MEMBER);
                this.sendMessageToAllPartyPlayers(ChatColor.AQUA + Bukkit.getOfflinePlayer((String)name).getName() + ChatColor.YELLOW + " was demoted to Party Member", ChatColor.BLUE, true);
            }
        });
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
        if (open) {
            this.sendMessageToAllPartyPlayers(ChatColor.GREEN + "The party is now open", ChatColor.BLUE, true);
        } else {
            this.sendMessageToAllPartyPlayers(ChatColor.RED + "The party is now closed", ChatColor.BLUE, true);
        }
    }

    public boolean isAllInvite() {
        return this.allInvite;
    }

    public void setAllInvite(boolean allInvite) {
        this.allInvite = allInvite;
    }

    public PartyPlayer getPartyLeader() {
        return this.partyPlayers.stream().filter(partyPlayer -> partyPlayer.getPartyPlayerType() == PartyPlayerType.LEADER).findFirst().get();
    }

    public String getLeaderName() {
        return Bukkit.getOfflinePlayer((UUID)this.getPartyLeader().getUuid()).getName();
    }

    public List<PartyPlayer> getPartyModerators() {
        return this.partyPlayers.stream().filter(partyPlayer -> partyPlayer.getPartyPlayerType() == PartyPlayerType.MODERATOR).sorted(Comparator.comparing(PartyPlayer::isOffline).thenComparing(PartyPlayer::isAFK)).collect(Collectors.toList());
    }

    public List<PartyPlayer> getPartyMembers() {
        return this.partyPlayers.stream().filter(partyPlayer -> partyPlayer.getPartyPlayerType() == PartyPlayerType.MEMBER).sorted(Comparator.comparing(PartyPlayer::isOffline).thenComparing(PartyPlayer::isAFK)).collect(Collectors.toList());
    }

    public PartyPlayer getPartyPlayerByUUID(UUID uuid) {
        return this.partyPlayers.stream().filter(partyPlayer -> partyPlayer.getUuid().equals(uuid)).findFirst().orElse(null);
    }

    public void sendMessageToAllPartyPlayers(String message, ChatColor borderColor, boolean centered) {
        this.getAllPartyPeoplePlayerOnline().forEach(partyMember -> ChatUtils.sendMessageToPlayer(partyMember, message, borderColor, centered));
    }

    public List<Player> getAllPartyPeoplePlayerOnline() {
        return Bukkit.getOnlinePlayers().stream().filter(player -> this.getPartyPlayers().stream().anyMatch(partyPlayer -> partyPlayer.getUuid().equals(player.getUniqueId()))).collect(Collectors.toList());
    }

    public List<PartyPlayer> getPartyPlayers() {
        return this.partyPlayers;
    }

    public boolean allOnlineAndNoAFKs() {
        return this.partyPlayers.stream().noneMatch(partyPlayer -> !partyPlayer.isOnline() || partyPlayer.isAFK());
    }

    public boolean hasUUID(UUID uuid) {
        return this.partyPlayers.stream().anyMatch(partyPlayer -> partyPlayer.getUuid().equals(uuid));
    }

    public void addPoll(PartyPoll poll) {
        this.polls.add(poll);
    }

    public List<PartyPoll> getPolls() {
        return this.polls;
    }

    public HashMap<UUID, Integer> getInvites() {
        return this.invites;
    }

    public RegularGamesMenu getRegularGamesMenu() {
        return this.regularGamesMenu;
    }
}

