/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

public class ParameterBindingContext {
    private final ValueProvider valueProvider;
    private final SpELExpressionEvaluator expressionEvaluator;

    public ParameterBindingContext(ValueProvider valueProvider, SpelExpressionParser expressionParser, EvaluationContext evaluationContext) {
        this(valueProvider, (ExpressionParser)expressionParser, () -> evaluationContext);
    }

    public ParameterBindingContext(ValueProvider valueProvider, final ExpressionParser expressionParser, final Supplier<EvaluationContext> evaluationContext) {
        this(valueProvider, new SpELExpressionEvaluator(){

            @Override
            public <T> T evaluate(String expressionString) {
                return (T)expressionParser.parseExpression(expressionString).getValue((EvaluationContext)evaluationContext.get(), Object.class);
            }
        });
    }

    public ParameterBindingContext(ValueProvider valueProvider, SpELExpressionEvaluator expressionEvaluator) {
        this.valueProvider = valueProvider;
        this.expressionEvaluator = expressionEvaluator;
    }

    public static ParameterBindingContext forExpressions(ValueProvider valueProvider, final ExpressionParser expressionParser, final Function<ExpressionDependencies, EvaluationContext> contextFunction) {
        return new ParameterBindingContext(valueProvider, new SpELExpressionEvaluator(){

            @Override
            public <T> T evaluate(String expressionString) {
                Expression expression = expressionParser.parseExpression(expressionString);
                ExpressionDependencies dependencies = ExpressionDependencies.discover(expression);
                EvaluationContext evaluationContext = (EvaluationContext)contextFunction.apply(dependencies);
                return (T)expression.getValue(evaluationContext, Object.class);
            }
        });
    }

    @Nullable
    public Object bindableValueForIndex(int index) {
        return this.valueProvider.getBindableValue(index);
    }

    @Nullable
    public Object evaluateExpression(String expressionString) {
        return this.expressionEvaluator.evaluate(expressionString);
    }

    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }
}

